package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class PasswordServiceImpl implements PasswordService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Value("${doubleWritingMode}")
    private boolean doubleWritingMode;

    @Override
    public void modifyPassword(Integer acctId, String oldPwd, String pwd) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByPrimaryKey(acctId);
        if (entity.getPassword().equals(oldPwd)) {
            Date currentTime = new Date();
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(acctId);
            accountInfoEntity.setModifiedId(acctId);
            accountInfoEntity.setModifiedTime(currentTime);
            accountInfoEntity.setPassword(pwd);
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            if (doubleWritingMode) {
                processDoubleWrite(acctId, pwd);
            }
            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(acctId, entity.getMobilePhone(),
                    oldPwd, pwd, AccountTypeEnum.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_PASSWORD_ERROR);
        }
    }

    @Override
    public void forgetPassword(BaseRequest request) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(request.getMobile()));
        if (entity != null) {
            String password = request.getPassword();
            Integer accId = entity.getId();
            Date currentTime = new Date();
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(accId);
            accountInfoEntity.setModifiedId(accId);
            accountInfoEntity.setModifiedTime(currentTime);
            accountInfoEntity.setPassword(password);
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            if (doubleWritingMode) {
                processDoubleWrite(accId, password);
            }
            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(accId, entity.getMobilePhone(),
                    "", request.getPassword(), AccountTypeEnum.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            //未注册，请先注册
            throw new AccountException(AccountExceptionEnum.PICA_NOT_REGISTER);
        }
    }

    /**
     * 双写模式，把密码存储到p_doctor表
     *
     * @param accId
     * @param password
     */
    private void processDoubleWrite(Integer accId, String password) {
        Date currentTime = new Date();
        Doctor doctor = new Doctor();
        doctor.setPassword(password);
        doctor.setAcctId(accId);
        doctor.setModifyTime(currentTime);
        doctor.setModifyId(accId);
        doctorMapper.updateByAcctId(doctor);
    }
}
