package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.common.req.CreateAccountReq;
import com.pica.cloud.account.account.server.App;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = App.class)
public class AccountServiceTest extends TestCase {
    @Autowired
    private AccountService accountService;

    @Test
    public void testCreateAccountV2() {
        CreateAccountReq req = new CreateAccountReq();
        req.setHospitalId(475838);
        req.setHospitalName("测试医院");
        req.setDoctorName("张三");
        req.setMobilePhone("13391420640");

        PicaUser picaUser = new PicaUser();
        picaUser.setId(1);
        accountService.createAccountV2(req, picaUser);
    }
}