// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.account.account.server.req.HospitalRoleDetailReq;
import com.pica.cloud.account.account.server.req.HospitalRoleListReq;
import com.pica.cloud.account.account.server.resp.HospitalRoleDetailDto;
import com.pica.cloud.account.account.server.resp.HospitalRoleResp;
import com.pica.cloud.account.account.server.service.HospitalSaasRoleService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author qinwh
 * @Date 2022/3/1 15:54
 */
@Api(description = "机构saas角色资源")
@RestController
@RequestMapping("/hospital")
public class HospitalSaasRoleController extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    HospitalSaasRoleService hospitalSaasRoleService;

    @ApiOperation("机构saas角色-新增或更新")
    @PostMapping(value = "/role/insertAndModify")
    @EnabledLoginValidate
    public PicaResponse<Integer> insertAndModify(@RequestBody HospitalRoleDetailReq req) {
        logger.info("insertAndModify:url:/hospital/role/insertAndModify.start:{}",JSON.toJSONString(req));
        PicaUser user = fetchPicaUser();
        return PicaResponse.toResponse(hospitalSaasRoleService.insertAndModify(req, user));
    }

    @ApiOperation("机构saas角色-删除")
    @DeleteMapping(value = "/role/delete/{id}")
    @EnabledLoginValidate
    public PicaResponse<Integer> delete(@PathVariable("id") Long id) {
        logger.info("delete: url:/hospital//role/delete/id.start:id={}",id);
        PicaUser user = fetchPicaUser();
        return PicaResponse.toResponse(hospitalSaasRoleService.delete(id, user));
    }

    @ApiOperation("机构saas平台角色列表")
    @PostMapping(value = "/role/listByPage")
    @EnabledLoginValidate
    public PicaResponse<HospitalRoleResp> listByPage(@RequestBody HospitalRoleListReq req) {
        logger.info("listByPage: url:/hospital/role/listByPage.start:{}",JSON.toJSONString(req));
        HospitalRoleResp hospitalRoleResp = hospitalSaasRoleService.listByPage(req);
        return PicaResponse.toResponse(hospitalRoleResp);
    }


    @ApiOperation("机构saas角色-角色详情")
    @GetMapping(value = "/role/getRoleDetail/{id}")
    @EnabledLoginValidate
    public PicaResponse<HospitalRoleDetailDto> getRoleDetail(@PathVariable("id") Long id) {
        logger.info("getRoleDetail: url:/hospital/role/getRoleDetail/id.start:id={}",id);
        return PicaResponse.toResponse(hospitalSaasRoleService.getRoleDetail(id));
    }
}