package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.service.TokenService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.utils.entity.PicaAdmin;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.Map;

/**
 * Created on 2019/9/10 9:35
 * author:crs
 * Description:获取随机token
 */
@Api(description = "获取游客token")
@RestController
public class TokenController extends AccountBaseController {

    @Autowired
    private TokenService tokenService;

    @ApiOperation(value = "获取token接口")
    @GetMapping(value = "/token")
    public PicaResponse<String> getRandomToken() {
        Map<String, Object> headersMap = super.getHeaders();
        String token = tokenService.getToken(headersMap);
        return PicaResponse.toResponse(token);
    }

    @ApiOperation(value = "token续时")
    @GetMapping(value = "/token/continue")
    public PicaResponse tokenContinueTime(
            @RequestHeader(value = "token") String token,
            @RequestHeader(value = "sourceType") Integer sourceType,
            @RequestParam(value = "seconds", required = false) Integer seconds) throws Exception {
        tokenService.tokenContinueTime(token, sourceType, seconds);
        return PicaResponse.toResponse();
    }

    @ApiIgnore
    @GetMapping(value = "/token/remove")
    public PicaResponse removeToken(@RequestParam("timestamp") Long timestamp) {
        tokenService.removeToken(timestamp);
        return PicaResponse.toResponse();
    }
}
