package com.pica.cloud.account.account.server.util;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.foundation.utils.utils.HttpClientUtil;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;

/**
 * @program: pica-cloud-account
 * @description:
 * @author: wfy
 * @create: 2020-02-12 17:45
 */
public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final CloseableHttpClient hc;

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(20);
        cm.setMaxTotal(200);
        hc = HttpClients.custom().setConnectionManager(cm).build();
    }

    public static <T> T postForm(String url, Map<String, String> params, Class<T> clazz) throws IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder(url);
        if (params != null && params.size() > 0) {
            params.forEach((k, v) -> {
                builder.setParameter(k, v);
            });
        }
        HttpPost post = new HttpPost(builder.build());
        CloseableHttpResponse resp = null;
        T data;
        try {
            resp = hc.execute(post);
            String buf = IOUtils.toString(resp.getEntity().getContent(), "utf-8");
            data = StringUtil.isNotNull(buf) ? JSON.parseObject(buf, clazz) : null;
        } finally {
            if (resp != null) {
                try {
                    resp.close();
                } catch (IOException var12) {
                    logger.error(var12.getMessage());
                }
            }
        }
        return data;
    }

    public static String getHttpExecute(String url, Map<String, String> headerParams) {
        String result = "";
        BufferedReader br = null;
        CloseableHttpResponse response = null;

        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Content-Type", "application/json;charset=utf-8");

            if(null!=headerParams){
                headerParams.forEach(httpGet::setHeader);
            }

            response = httpClient.execute(httpGet);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));

            for(String output = null; (output = br.readLine()) != null; result = output) {
                ;
            }
        } catch (MalformedURLException var22) {
            logger.error("获取session出错:" + var22);
        } catch (IOException var23) {
            logger.error("获取session出错:" + var23);
        } finally {
            try {
                if (br != null) {
                    br.close();
                }
            } catch (Exception var21) {
                logger.warn("IOException关闭异常");
            }

            try {
                if (response != null) {
                    response.close();
                }
            } catch (Exception var20) {
                logger.warn("CloseableHttpResponse关闭异常");
            }

        }

        return result;
    }
}
