package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * Created on 2019/9/10 18:51
 * author:crs
 * Description:云鹊医 获取用户信息资源
 */
@Api(description = "云鹊医用户信息信息资源")
@RestController
@RequestMapping("/doctor")
public class DoctorController extends AccountBaseController {

    @Autowired
    private DoctorService doctorService;

    @ApiOperation("获取医生信息用接口")
    @GetMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse<Doctor> getDoctorInfo() {
        AccountUser accountUser = null;
        try {
            accountUser = super.getAccountUser();
        } catch (Exception e) {
            e.printStackTrace();
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
        Integer userId = accountUser.getId();
        Doctor doctorInfo = doctorService.getDoctorInfo(userId);
        return PicaResponse.toResponse(doctorInfo);
    }

    @ApiOperation("修改医生信息接口")
    @PutMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse modifyDoctorInfo(@RequestBody Doctor doctor) {
        AccountUser accountUser = null;
        try {
            accountUser = super.getAccountUser();
        } catch (Exception e) {
            e.printStackTrace();
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
        Integer userId = accountUser.getId();
        doctor.setId(userId);
        doctorService.modifyDoctorInfo(doctor);
        return PicaResponse.toResponse();
    }


    //TODO: 2019/9/11 doctor服务已经有这两个接口了  暂时不需要提供


}
