package com.pica.cloud.account.account.server.enums;

/**
 * Created on 2019/8/27
 * author:crs
 * Description:账户常用异常类型定义
 */
public enum AccountExceptionEnum {

    PICA_NOT_EMPTY("216501", "字段非空提示信息"),
    PICA_MOBILE_ERROR("216502", "请输入正确的手机号"),
    PICA_SYSCODE_ERROR("216503", "短信验证码错误"),
    PICA_SYSCODE_EXPIRE("216504", "短信验证码已过期，请重新获取"),
    PICA_SYSCODE_RESET("216505", "请X秒后重试（获取验证码），请重新获取"),
    PICA_SYSCODE_LATER("216506", "验证码获取过于频繁，请隔天后重试"),
    PICA_ALREADY_REGISTER("216507", "该手机号已注册，请直接登录"),
    PICA_NOT_REGISTER("216508", "未注册,请先注册"),
    PICA_PASSWORD_ERROR("216509", "请输入正确的密码"),
    PICA_IMAGE_PASSWORD_ERROR("216511", "图形验证码错误"),
    PICA_LOGIN_AGAIN("216512", "请重新登录"),
    PICA_PASSWORD_NULL("216513", "密码不能为空"),
    PICA_PASSWORD_EQUAL("216514", "旧密码与新密码不能相同"),
    PICA_UNBIND_MOBILE("216515", "该手机号未绑定微信"),
    PICA_MOBILE_SAME("216516", "新手机号与旧手机号不能相同"),
    PICA_PARAMS_ERROR("216517", "传递参数有误"),
    PICA_SYSCODE_RETRY("216518", "请X秒后重试"),
    PICA_NOT_EXIST("216519", "该用户不存在"),
    PICA_REGISTER_FAIL("216520", "注册失败"),
    PICA_WECHAT_CODE_ERROR("216521", "微信登录授权code不正确"),
    PICA_WECHAT_UNBIND("216522", "该微信号已绑定其他云鹊医账户，你可以使用微信登录云鹊医，在「设置」页解除绑定"),
    PICA_WECHAT_BIND_OTHER("216524", "该手机号已绑定其他微信号，你可以在「设置」页解除绑定"),
    PICA_WECHAT_UNBIND_CURRENT("216523", "正在绑定中,请稍等"),
    PICA_PASSWORD_RULE_ERROR("216525","该手机号{mobile}尚未设置密码，请先设置密码。"),
    PICA_PWD_MISMATCH_4("216526", "密码错误,请重试"),
    PICA_PWD_MISMATCH_5("216527", "该账号{mobile}的密码错误次数已达上限请24小时后再试，或请使用其他登录方式或找回密码"),
    PICA_APPLE_TOKEN_ERROR("216528", "Apple登录授权token不正确"),
    PICA_APPLE_BIND_OTHER("216529", "该Apple账号已绑定其他账户"),
    PICA_MOBILE_BIND_OTHER("216530", "该手机号已绑定其他Apple账号"),

    PICA_MOBILE_REG_FALSE("216531", "请输入正确的手机号"),
    PICA_MOBILE_NOT_REGIST("216533", "该手机号{mobile}尚未设置密码，请先设置密码。"),
    PICA_MOBILE_NOT_SETED_PASSWORD("216534", "该手机号{mobile}尚未设置密码，请先设置密码。"),
    // 风控禁止发送
    PICA_RC_SEND_FAIL("216536", "发送异常"),
    PICA_RC_TRIGGER("216537", "需要触发风控滑动验证"),
    //  账号、IP、设备在黑名单内，前端提示发送成功,后端不发送短信
    PICA_RC_BLACKLIST("216538", "发送成功"),
    PICA_RC_DAY_LIMIT("216539", "今日获取验证码次数已超过上限，请使用账户密码登录"),
    PICA_RC_60_SECOND_LIMIT("216540", "验证码发送频率过高，请{remainTime}秒后再试"),
    PICA_H5_AUTH_CODE_INTERFACE_OFFED("216541", "该功能已关闭"),
    PICA_MESSAGE_SERVICE_CALL_FAIL("216542", "短信发送失败"),
    PICA_BIND_WECHAT_FAIL("216543", "绑定微信失败"),


    xxx_xxx("","");


    private String code;
    private String message;

    AccountExceptionEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

