package com.pica.cloud.account.account.server.mapper;


import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;

public interface AccountPatientInfoMapper {


    /**
     * 通过userId查询居民信息
     *
     * @param id userId
     * @return
     */
    AccountPatientInfoEntity selectByPrimaryKey(Integer id);

    /**
     * 通过用户id查询居民信息
     *
     * @param id 用户id
     * @return
     */
    AccountPatientInfoEntity selectByUserId(Integer id);


    /**
     * 通过账户id查询账户信息
     *
     * @param acctId
     * @return
     */
    AccountPatientInfoEntity selectByAcctId(Integer acctId);

    /**
     * 更新居民信息接口
     *
     * @param record 居民信息模型
     * @return
     */
    int updateByPrimaryKeySelective(AccountPatientInfoEntity record);


    int insertSelective(AccountPatientInfoEntity record);

    int updateByPrimaryKey(AccountPatientInfoEntity record);

    int deleteByPrimaryKey(Integer id);

    int insert(AccountPatientInfoEntity record);

}