//
package com.pica.cloud.account.account.server.configuration;

import com.pica.cloud.foundation.kafka.producer.ISimpleProducer;
import com.pica.cloud.foundation.kafka.producer.SimpleProducer;
import com.pica.cloud.foundation.service.starter.SpringContextAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @ClassName BeanConfiguration
 * @Description TODO
 * @Author wangxinxu
 * @Date 2019/9/17 上午10:59
 * @ModifyDate 2019/9/17 上午10:59
 * @Version 1.0
 */
@Configuration
public class BeanConfiguration {

    @Autowired
    private PropertiesConfiguration propertiesConfiguration;

    @Autowired
    SpringContextAware springContextAware;

    // 定义 ISimplerProducer bean 默认投递模式为 Delivery.AT_LEAST_ONCE
    // Key：类型为String
    // Value：类型为PicaUser
    @Bean
    public ISimpleProducer<String, Object> simpleProducer() {
        return new SimpleProducer<>(springContextAware.getActiveProfile());
    }

}
