package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeReq;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.enums.SourceTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.service.CaptchaService;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.TokenService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.account.account.server.util.RSAUtil;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.redis.CacheClient;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import com.pica.cloud.foundation.service.starter.interceptor.LoginPermission;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@Api(description = "登录资源")
@RestController
public class LoginController extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private LoginService loginService;

    @Autowired
    private ICacheClient redisClient;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private TokenService tokenService;

    @Autowired
    private DoctorService doctorService;

    @Autowired
    private CacheClient cacheClient;

    private String cache_prifix = "cache-";

    @Autowired
    private CaptchaService captchaService;

    /**
     * 密码登录接口（app、H5、web）
     *
     * @param authCodeReq
     * @return
     * @throws Exception
     */
    @ApiOperation("密码登录接口")
    @PostMapping("/login")
    public PicaResponse<LoginResult> loginByPassword(@RequestBody AesAuthCodeReq authCodeReq) throws Exception {

        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(authCodeReq.getKey()) && StringUtils.isEmpty(authCodeReq.getContent())){
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(authCodeReq);
            logger.info("AesAuthCodeReq loginByPassword:" + JSONObject.toJSONString(authCodeReq));
            logger.info("AesAuthCodeReq loginByPassword encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(4);
            loginAes.setDeviceToken(authCodeReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(authCodeReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(authCodeReq.getKey());
            entity.setContent(authCodeReq.getContent());
        }
        //added by joy end

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        LoginResult login = loginService.login(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

    /**
     * 一键登录-验证码登录
     *
     * @param authCodeReq
     * @return
     * @throws Exception
     */
    @ApiOperation("PC,App端验证码登录接口，需要完善信息")
    @PostMapping(value = "/login-register")
    public PicaResponse<LoginResult> loginAndRegister(@RequestBody AesAuthCodeReq authCodeReq) throws Exception {
        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(authCodeReq.getKey()) && StringUtils.isEmpty(authCodeReq.getContent())){
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(authCodeReq);
            logger.info("AesAuthCodeReq loginAndRegister:" + JSONObject.toJSONString(authCodeReq));
            logger.info("AesAuthCodeReq loginAndRegister encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(5);
            loginAes.setDeviceToken(authCodeReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(authCodeReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(authCodeReq.getKey());
            entity.setContent(authCodeReq.getContent());
        }
        //added by joy end
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("login-register:{}",JSONObject.toJSONString(request));
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        LoginResult login = loginService.loginAndRegister(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

    @ApiOperation("微信登录接口")
    @PostMapping(value = "/login/wechat")
    public PicaResponse<LoginResult> loginByWeChat(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        LoginResult result = loginService.loginByWeChat(request);
        return PicaResponse.toResponse(result);
    }

    @ApiOperation("微信登录第二步接口")
    @PostMapping(value = "/login/wechat/step2")
    public PicaResponse<LoginResult> loginByWeChatStep(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("loginByWeChatStep:{}",JSONObject.toJSONString(request));
        LoginResult result = loginService.loginByWeChatStep(request);
        return PicaResponse.toResponse(result);
    }

    /**
     * 绑定微信接口
     *
     * @param entity
     * @return
     * @throws Exception
     */
    @ApiOperation("绑定微信接口")
    @PostMapping("/login/wechat/bind")
    public PicaResponse bindWeChat(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("bindWeChat:{}",JSONObject.toJSONString(request));
        request.setUserTokenTourist(super.getUserTokenTourist());
        Long result = cacheClient.setnx(cache_prifix + request.getWeChatCode(), request.getWeChatCode());
        if (result == 1) {
            try {
                cacheClient.expire(cache_prifix + request.getWeChatCode(), 60);
                long doctorId = super.getDoctorIdByToken();
                logger.info("bindWeChat doctorId:{}",doctorId);
//                String nickname = loginService.bindWeChat(doctorId, request);
                Map<String,String> rtnMap = loginService.bindWeChatMap(doctorId, request);

//                Map<String, String> map = new HashMap();
//                map.put("nickname", rtnMap.get("nickname"));
                //成功以后释放锁
                cacheClient.del(cache_prifix + request.getWeChatCode());
                return PicaResponse.toResponse(rtnMap);
            } catch (Exception e) {
                cacheClient.del(cache_prifix + request.getWeChatCode());
                logger.error("bindWeChat-" + e.getMessage(), e);
                if(e instanceof PicaException) {
                    throw new PicaException(((PicaException) e).getCode(), ((PicaException) e).getMsg());
                }
                throw new PicaWarnException(AccountExceptionEnum.PICA_BIND_WECHAT_FAIL.getCode(), AccountExceptionEnum.PICA_BIND_WECHAT_FAIL.getMessage());
            }
        } else {
            return PicaResponse.toResponse(null, AccountExceptionEnum.PICA_WECHAT_UNBIND_CURRENT.getCode(),
                    AccountExceptionEnum.PICA_WECHAT_UNBIND_CURRENT.getMessage());
        }
    }

    @ApiOperation("微信解除绑定接口")
    @PutMapping("/login/wechat/unbind")
    public PicaResponse unbindWeChat() {
        long doctorId = super.getDoctorIdByToken();
        loginService.unbindWeChat(doctorId);
        return PicaResponse.toResponse();
    }

    /**
     * 退出登录接口，返回一个随机token
     * 1)登录状态调用，2)清除token
     *
     * @return
     */
    @ApiOperation(value = "退出登录接口")
    @GetMapping("/logout")
    public PicaResponse<String> loginOut() {
        String token = super.getTokenFromHeader();
        if (StringUtils.isNotEmpty(token)) {
            Long doctorId = super.getDoctorIdByToken();
            Doctor doctorInfo = doctorService.getDoctorInfo(doctorId.intValue());
            Map<String, Object> headersMap = super.getHeaders();
            if (StringUtil.isNotNull(doctorInfo)) {
                Integer acctId = doctorInfo.getAcctId();
                redisClient.deleteToken(token);
                String newToken = tokenService.getToken(headersMap);
                LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, super.getProductType(), super.getSourceType(),
                        AccountTypeEnum.LOGIN_OUT.getCode(), super.getIpAddr(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode(),
                        newToken,0,super.getUserTokenTourist());
                picaLogUtils.info(entity);
                return PicaResponse.toResponse(newToken);
            } else {
                String newToken = tokenService.getToken(headersMap);
                return PicaResponse.toResponse(newToken);
            }
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
    }

    @ApiOperation(value = "web登录获取用户信息")
    @GetMapping("/login/web")
    public PicaResponse<LoginResultWeb> getLoginResult() {
        LoginResultWeb resultWeb = new LoginResultWeb();
        long doctorId = super.getDoctorIdByToken();
        if (doctorId <= 0) {
            resultWeb.setIsExist(2);
            return PicaResponse.toResponse(resultWeb);
        }

        PICAPDoctor doctor = loginService.queryDoctor(doctorId);
        resultWeb.setPicapDoctor(doctor);
        if (doctor.getStatus() != null) {
            resultWeb.setCertifyDoc(doctor.getStatus().intValue());
        }
        return PicaResponse.toResponse(resultWeb);
    }

    @ApiOperation(value = "统一校验(传空则不会校验)")
    @PostMapping("/unifiedVerification")
    public PicaResponse unifiedVerification(@RequestBody AesAuthCodeReq req) throws Exception{

        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(req.getKey()) && StringUtils.isEmpty(req.getContent())){
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(req);
            logger.info("AesAuthCodeReq unifiedVerification:" + JSONObject.toJSONString(req));
            logger.info("AesAuthCodeReq unifiedVerification encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(2);
            loginAes.setDeviceToken(req.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(req.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(req.getKey());
            entity.setContent(req.getContent());
        }
        //added by joy end

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setSourceType(super.getSourceType());
        logger.info("unifiedVerification:{}",JSONObject.toJSONString(request));
        loginService.preLoginValidate(request);
        return PicaResponse.toResponse();
    }

    @ApiOperation(value = "苹果授权登录")
    @PostMapping("/login/apple")
    public PicaResponse appleAuth(@RequestBody EncryptEntity entity) throws Exception{
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("appleAuth:{}", JSONObject.toJSONString(request));
        return PicaResponse.toResponse(loginService.loginByApple(request));
    }

    @ApiOperation(value = "苹果登录绑定手机号")
    @PostMapping("/login/apple/step2")
    public PicaResponse appleAuthBind(@RequestBody EncryptEntity entity) throws Exception{
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("appleAuthBind:{}",JSONObject.toJSONString(request));
        return PicaResponse.toResponse(loginService.loginByAppleStep(request));
    }

    @ApiOperation(value = "苹果登录-跳过绑定-静默注册")
    @PostMapping("/login/apple/skip/register")
    public PicaResponse appleSkipRegister(@RequestBody EncryptEntity entity) throws Exception{
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("appleSkipRegister:{}",JSONObject.toJSONString(request));
        return PicaResponse.toResponse(loginService.appleSkipRegister(request));
    }


    @ApiOperation(value = "app端手机号码一键登录")
    @PostMapping("/login/one-click")
    public PicaResponse<LoginResult> oneClickLogin(@RequestBody AesAuthCodeReq aesReq) throws Exception {

        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(aesReq.getKey()) && StringUtils.isEmpty(aesReq.getContent())){
            //明文时处理
            entity = RSAUtil.getOneClickEncrypt(aesReq);
            logger.info("AesAuthCodeReq oneClickLogin:" + JSONObject.toJSONString(aesReq));
            logger.info("AesAuthCodeReq oneClickLogin encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(3);
            loginAes.setDeviceToken(aesReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setOneToken(aesReq.getToken());
            loginAes.setMobile(aesReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(aesReq.getKey());
            entity.setContent(aesReq.getContent());
        }
        //added by joy end

        OneClickLoginReq req = CryptoUtil.decrypt(entity, OneClickLoginReq.class);
        req.setProductType(super.getProductType());
        req.setSourceType(super.getSourceType());
        req.setLoginIp(super.getIpAddr());
        req.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("one-click req:{}",JSONObject.toJSONString(req));
        LoginResult oneClickLoginResultVo = loginService.oneClickLogin(req);
        return PicaResponse.toResponse(oneClickLoginResultVo);
    }

    @ApiOperation(value = "web登录-图形码")
    @PostMapping("/web/captchaPwd")
    public PicaResponse<LoginResult> webCaptchaPwd(@RequestBody EncryptEntity entity,
                                                   HttpServletRequest req) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("webCaptchaPwd:{}", JSONObject.toJSONString(request));
        String captchaToken = request.getCaptchaToken();
        String captchaAnswer = request.getCaptchaAnswer();
        //校验图形验证码
        if (!captchaService.acknowledge(captchaToken, captchaAnswer)) {
            return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "图形验证码错误");
        }

        //原登录逻辑
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        LoginResult login = loginService.login(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

    @ApiOperation(value = "二维码扫码登录")
    @PostMapping("/login/QRCode")
    @EnabledLoginValidate
    public PicaResponse<String> loginQRCode() {
        BaseRequest request = new BaseRequest();
        request.setProductType(1);
        request.setSourceType(3);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        request.setMobile(this.fetchPicaUser().getMobile());
        LoginResult login = loginService.loginQRCode(request);

        return PicaResponse.toResponse(login.getToken());
    }

    @ApiOperation(value = "切换登录")
    @PostMapping("/login/switch")
    @EnabledLoginValidate
    public PicaResponse<String> loginSwitch(@RequestBody EncryptEntity entity) throws Exception {
        Map<String, Object> req = CryptoUtil.decrypt(entity, Map.class);
        loginService.loginSwitch(super.getAccountUser(), cacheClient.getToken(String.valueOf(req.get("token")), AccountUser.class));
        return PicaResponse.toResponse();
    }


    /**
     * saas机构管理平台密码登录接口
     * 
     * @author wenlei.liao
     * @date 2022/3/1 18:45
     * @param
     * @return 
    */
    @ApiOperation("saas机构管理平台密码登录接口")
    @PostMapping("/saasLogin")
    public PicaResponse<SaasLoginResult> saasLogin(@RequestBody SaasLoginReq authCodeReq) throws Exception {
        EncryptEntity entity = new EncryptEntity();
        entity.setKey(authCodeReq.getKey());
        entity.setContent(authCodeReq.getContent());
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        SaasLoginResult login = loginService.saasLogin(request);
        return PicaResponse.toResponse(login);
    }
}
