package com.pica.cloud.account.account.server.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.LogLoginOnekey;
import com.pica.cloud.account.account.server.entity.MobileDataEntity;
import com.pica.cloud.account.account.server.entity.QueryMobileEntity;
import com.pica.cloud.account.account.server.mapper.LogLoginOnekeyMapper;
import com.pica.cloud.account.account.server.util.*;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @program: pica-cloud-account
 * @description:
 * @author: wfy
 * @create: 2020-02-24 13:57
 */
@Component
public class OneClickProcessor {
    @Autowired
    private IntactUtil intactUtil;
    private static final String DEFAULT_ENCRYPT_TYPE = "0";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    //手机号加解密方式 0 AES 1 RSA , 可以不传，不传则手机号解密直接使用AES解密
    private String aesEncryptType = DEFAULT_ENCRYPT_TYPE;
    private String rsaEncryptType = "1";
    private String encryptType = DEFAULT_ENCRYPT_TYPE;
    private static final String SHANYAN_SUCCESS_CODE = "200000";
    //创建应用时填入的rsa公钥对应的私钥字符串
    public static final String privateKey = "";
    public static final Integer TYPE_IOS = 2;
    public static final Integer TYPE_ANDROID = 1;
    private static final String TOKEN = "token";
    private static final String APPID = "appId";
    private static final String ENCRYPT_TYPE = "encryptType";
    private static final String SIGN = "sign";

    @Value("${shanyan.url.mobilequery}")
    private String mobileQueryUrl;
    @Value("${shanyan.android.appId}")
    private String androidAppId;
    @Value("${shanyan.android.appKey}")
    private String androidAppKey;
    @Value("${shanyan.ios.appId}")
    private String iosAppId;
    @Value("${shanyan.ios.appKey}")
    private String iosAppKey;

    @Autowired
    private LogLoginOnekeyMapper logLoginOnekeyMapper;

    public QueryMobileEntity tokenExchangeMobile(String token, Integer type) {
        if (type == null || StringUtils.isEmpty(token)) {
            return null;
        }
        String appId;
        String appKey;
        if (type.equals(TYPE_ANDROID)) {
            appId = androidAppId;
            appKey = androidAppKey;
        } else if (type.equals(TYPE_IOS)) {
            appId = iosAppId;
            appKey = iosAppKey;
        } else {
            return null;
        }
        //从SDK获取的token参数
        QueryMobileEntity queryMobileEntity = null;
        try {
            Map<String, String> params = new HashMap<>();
            params.put(TOKEN, token);
            params.put(APPID, appId);
            params.put(ENCRYPT_TYPE, encryptType);//可以不传，不传则解密直接使用AES解密
            params.put(SIGN, SignUtils.getSign(params, appKey));
            //接入新旭事务一致性
            String batchNo = IntactUtils.getUUID();
            intactUtil.sendIntact(batchNo,"tokenExchangeMobile.postForm(mobileQueryUrl, params, QueryMobileEntity.class)",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"token:"+token+",appId:"+appId+",SIGN:"+SignUtils.getSign(params, appKey) );
            queryMobileEntity = HttpUtil.postForm(mobileQueryUrl, params, QueryMobileEntity.class);
            intactUtil.sendIntact(batchNo,"tokenExchangeMobile.postForm(mobileQueryUrl, params, QueryMobileEntity.class)",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"queryMobileEntity:"+JSON.toJSONString(queryMobileEntity) );

            if (null != queryMobileEntity) {
                logger.info("一键登录token换取手机号结果：{}", queryMobileEntity);
                String code = queryMobileEntity.getCode();     //返回码 200000为成功
                if (SHANYAN_SUCCESS_CODE.equals(code)) {
                    MobileDataEntity mobileDataEntity = queryMobileEntity.getData();
                    String mobile = mobileDataEntity.getMobileName();
                    if (aesEncryptType.equals(encryptType)) {
                        String key = MD5.getMD5Code(appKey);
                        mobile = AESUtil.decrypt(mobile, key.substring(0, 16), key.substring(16));
                    } else if (rsaEncryptType.equals(encryptType)) {
                        mobile = RSAUtil.decryptByPrivateKeyForLongStr(mobile, privateKey);
                    }
                    queryMobileEntity.setMobile(mobile);
                }
            }
        } catch (Exception e) {
            logger.error("one-click req tokenExchangeMobile:{}",e.getMessage());
        }
        return queryMobileEntity;
    }

    @Async
    public void savelogLoginOnekey(QueryMobileEntity queryMobileEntity,Integer logLoginId) {
        LogLoginOnekey l = new LogLoginOnekey();
        l.setDeviceType(queryMobileEntity.getSourceType());
        MobileDataEntity data = queryMobileEntity.getData();
        l.setFanqizha(data.getFanqizha());
        l.setTradeNo(data.getTradeNo());
        l.setMobile(AESUtil.encryptV0(queryMobileEntity.getMobile()));
        l.setLogLoginId(logLoginId);
        l.setInfo(JSONObject.toJSONString(queryMobileEntity));
        Date d = new Date();
        l.setCreateId(-1);
        l.setCreateTime(d);
        l.setModifyId(-1);
        l.setModifyTime(d);
        logLoginOnekeyMapper.insertSelective(l);
    }
}
