package com.pica.cloud.account.account.server.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @Description ThreadPoolConfig
 * @Author Chongwen.jiang
 * @Date 2020/2/27 16:37
 * @ModifyDate 2020/2/27 16:37
 * @Params
 * @Return
 */
@Configuration
public class ThreadPoolConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean(name = "accountThreadPool")
    public ThreadPoolTaskExecutor getExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(3);
        executor.setMaxPoolSize(10);
        executor.setQueueCapacity(100);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("account_ThreadPool");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        logger.info("accountThreadPool init end-");
        return executor;
    }
}
