package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.common.req.circle.CircleAcctInit;
import com.pica.cloud.account.account.common.req.circle.CircleAcctInitReq;
import com.pica.cloud.account.account.common.req.shop.ShopAcctInit;
import com.pica.cloud.account.account.common.req.shop.ShopAcctInitReq;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.mapper.AccountMapper;
import com.pica.cloud.account.account.server.service.AccountService;
import com.pica.cloud.account.account.server.service.CircleAccountService;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


/**
 * @DESCRIPTOIN:
 * @AUTHOR: joy
 * @DATE:2020/6/21 10:25 上午
 */
@Service
public class CircleAccountServiceImpl implements CircleAccountService {

    private static Logger logger = LoggerFactory.getLogger(CircleAccountServiceImpl.class);

    @Autowired
    private AccountService accountService;

    @Autowired
    private AccountMapper accountMapper;

    @Override
    @Transactional
    public List<Integer> createCircleAccount(CircleAcctInitReq circleAcctInitReq) {
        logger.info("createCircleAccount:{}", JSONObject.toJSONString(circleAcctInitReq));
        List<CircleAcctInit> circleAcctInits = circleAcctInitReq.getCircleAcctInitList();
        List<Integer> savedIds = new ArrayList<>();
        try {
            for(CircleAcctInit acct : circleAcctInits){
                Account dbAcct = accountMapper.getByMobilePhone(acct.getEncryMobile());  //获取医生表账号信息
                if(null == dbAcct){
                    Account account = new Account();
                    account.setName(acct.getUserName());
                    account.setNickname(acct.getUserName());
                    account.setMobilePhone(acct.getEncryMobile());
                    account.setRegisterSource(circleAcctInitReq.getRegisterSource());
                    accountService.createAccount(account,AccountTypeEnum.PRODUCT_TYPE_ECO_LIVE.getCode());
                    savedIds.add(account.getId().intValue());
                    logger.info("createCircleAccount insert {}",account.getId().intValue());
                }else {
                    savedIds.add(dbAcct.getId().intValue());
                    logger.info("createCircleAccount exist {}",dbAcct.getId().intValue());
                }
            }
        }catch (Exception e){
            logger.error("createCircleAccount error:{}",e.getMessage());
            throw e;
        }

        return savedIds;
    }

    @Override
    public List<Integer> createShopAccount(ShopAcctInitReq shopAcctInitReq) {
        logger.info("createShopAccount:{}", JSONObject.toJSONString(shopAcctInitReq));
        List<ShopAcctInit> shopAcctInits = shopAcctInitReq.getShopAcctInitList();
        List<Integer> savedIds = new ArrayList<>();
        try {
            for(ShopAcctInit acct : shopAcctInits){
                String encryMobile = EncryptUtils.encryptContent(acct.getMobile(), EncryptConstants.ENCRYPT_TYPE_MOBILE);
                Account dbAcct = accountMapper.getByMobilePhone(encryMobile);  //获取医生表账号信息
                if(null == dbAcct){
                    Account account = new Account();
                    account.setName(acct.getUserName());
                    account.setNickname(acct.getUserName());
                    account.setMobilePhone(encryMobile);
                    account.setRegisterSource(shopAcctInitReq.getRegisterSource());
                    accountService.createAccount(account,AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode());
                    savedIds.add(account.getId().intValue());
                    logger.info("createShopAccount insert {}",account.getId().intValue());
                }else {
                    savedIds.add(dbAcct.getId().intValue());
                    logger.info("createShopAccount exist {}",dbAcct.getId().intValue());
                }
            }
        }catch (Exception e){
            logger.error("createShopAccount error:{}",e.getMessage());
            throw e;
        }

        return savedIds;
    }

}
