package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.common.req.AcctPatInfoReq;
import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;

public interface PatientInfoService {


    /**
     * 更新用户信息接口
     *
     * @param accountPatientInfoEntity 更新信息
     */
    void updateUserInfo(AccountPatientInfoEntity accountPatientInfoEntity);

    void updateUserInfoV2(AcctPatInfoReq infoReq);


    /**
     * 获取用户信息接口
     *
     * @param userId 用户id
     * @return
     */
    AccountPatientInfoEntity getUserInfo(Integer userId);

    /**
     * 获取用户信息接口
     *
     * @param acctId 账户id
     * @return
     */
    AccountPatientInfoEntity getUserInfoByAcctId(Integer acctId);


    /**
     * 添加居民用户
     *
     * @param entity 居民信息
     */
    void addPatientInfo(AccountPatientInfoEntity entity, Integer userId);

    String getUnionIdByPatientId(Integer patientId);
}
