package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.util.AESUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * Created on 2019/9/11 11:02
 * author:crs
 * Description:医生相关Service
 */
@Service
public class DoctorServiceImpl implements DoctorService {

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Override
    public Doctor getDoctorInfo(Integer id) {
        return doctorMapper.selectByPrimaryKey(id);
    }

    @Override
    public void modifyDoctorInfo(Doctor doctor) {
        doctor.setModifyTime(new Date());
        doctorMapper.insertSelective(doctor);
    }

    /**
     * 客服管理后台添加医生
     * 1)当前医生信息是否存在,如果已经存在直接抛出异常；
     * 2)账户表和医生表；
     * 3)手机号进行加密存储；
     * 4)账户基本信息的处理:姓名,性别,年龄,生日,身份证号；
     *
     * @param doctor 新的医生数据
     * @param userId
     */
    @Override
    @Transactional
    public void addDoctorInfo(Doctor doctor, Integer userId) {
        String mobilePhone = doctor.getMobilePhone();
        String mobileEncrypt = AESUtil.encryptV0(mobilePhone);
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobileEncrypt);
        if (accountInfoEntity != null) {
            throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER);
        }
        String password = doctor.getPassword();
        Date currentTime = new Date();
        AccountInfoEntity entity = new AccountInfoEntity();
        entity.setMobilePhone(mobileEncrypt);
        entity.setPassword(password);
        entity.setCreatedTime(currentTime);
        entity.setModifiedTime(currentTime);
        entity.setModifiedId(userId);
        entity.setRegisterProduct(1);
        entity.setRegTime(currentTime);
        entity.setRegisterSource(3);
        entity.setCreatedId(userId);
        entity.setDeleteFlag(1);
        entity.setSex(doctor.getSex());
        entity.setName(doctor.getName());
        entity.setIdCard(doctor.getCard());
        entity.setAge(doctor.getAge());
        entity.setBirthday(doctor.getBirthday());
        accountInfoDetailMapper.insertSelective(entity);
        doctor.setAcctId(entity.getId());
        doctor.setMobilePhone(mobileEncrypt);
        doctor.setModifyId(userId);
        doctor.setCreatId(userId);
        doctor.setCreatTime(currentTime);
        doctor.setModifyTime(new Date());
        doctor.setDeleteFlag(1);
        doctorMapper.insertSelective(doctor);
    }
}
