package com.pica.cloud.account.account.server.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountUnionMapper;
import com.pica.cloud.account.account.server.mapper.AccountWeChatInfoMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.account.account.server.util.WeChatUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
public class LoginServiceImpl implements LoginService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUnionMapper accountUnionMapper;

    @Autowired
    private AccountWeChatInfoMapper accountWeChatInfoMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private RegisterService registerService;

    @Autowired
    private DoctorMapper doctorInfoMapper;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Value("${doubleWritingMode}")
    private boolean doubleWritingMode;

    @Value("${weChatAppID}")
    private String appId;
    @Value("${weChatAppSecret}")
    private String appSecret;
    @Value("${weChatURL}")
    private String weChatURL;

    @Override
    public String login(BaseRequest request) {
        String mobile = request.getMobile();
        String encrypt = AESUtil.encryptV0(mobile);
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(encrypt);
        if (accountInfoEntity != null) {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            if (password.equals(oldPwd)) {
                Date currentTime = new Date();
                Integer acctId = accountInfoEntity.getId();
                int productType = request.getProductType();
                int sourceType = request.getSourceType();
                Long userId = accountUtils.getUserIdByAcctId(productType, acctId);
                Account account = new Account();
                account.setId(userId);
                account.setAcctId(acctId);
                account.setCreatTime(currentTime);
                account.setMobilePhone(mobile);
                account.setRegisterSource(sourceType);
                String newToken = tokenUtils.generateToken(account);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(Constants.TOKEN, newToken);
                jsonObject.put(Constants.USER_ID, userId);
                if (productType == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
                    Doctor doctorEntity = doctorInfoMapper.selectByPrimaryKey(userId.intValue());
                    jsonObject.put(Constants.USER_ENTIRE_FLAG, doctorEntity.getEntireFlag());
                }
                LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, request.getSourceType(),
                        AccountTypeEnum.LOGIN_PWD.getCode(), request.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(),
                        AccountTypeEnum.LOG_TYPE_LOGIN.getCode());
                picaLogUtils.info(entity);
                return jsonObject.toJSONString();
            } else {
                logger.info("login failure：" + mobile);
                throw new PicaException(AccountExceptionEnum.PICA_PASSWORD_ERROR.getCode(), AccountExceptionEnum.PICA_PASSWORD_ERROR.getMessage());
            }
        } else {
            throw new PicaException(AccountExceptionEnum.PICA_NOT_REGISTER.getCode(), AccountExceptionEnum.PICA_NOT_REGISTER.getMessage());
        }
    }

    @Override
    public String loginAndRegister(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(mobile));
        if (accountInfoEntity == null) {
            return registerService.register(baseRequest);
        } else {
            return processLogin(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_CODE.getCode());
        }
    }

    /**
     * 登录逻辑处理
     *
     * @param baseRequest
     */
    private String processLogin(BaseRequest baseRequest, Integer acctId, Integer loginType) {
        Date currentTime = new Date();
        Long userId = accountUtils.getUserIdByAcctId(baseRequest.getProductType(), acctId);
        Account account = new Account();
        account.setId(userId);
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(baseRequest.getMobile());
        account.setRegisterSource(baseRequest.getSourceType());
        String newToken = tokenUtils.generateToken(account);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(Constants.TOKEN, newToken);
        jsonObject.put(Constants.USER_ID, userId);
        //是否完善过个人信息（云鹊医app才需要）
        if (baseRequest.getProductType() == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
            Doctor doctorEntity = doctorInfoMapper.selectByPrimaryKey(userId.intValue());
            jsonObject.put(Constants.USER_ENTIRE_FLAG, doctorEntity.getEntireFlag());
        }
        //记录登录日志
        LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, baseRequest.getProductType(), baseRequest.getSourceType(),
                loginType, baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode());
        ;
        picaLogUtils.info(entity);
        return jsonObject.toJSONString();
    }

    @Override
    public String loginByWeChat(BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        //todo：微信登录获取个人信息
        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());
        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountUnionEntity accountUnionEntity = accountUnionMapper.selectByUnionId(unionId);
        if (accountUnionEntity != null) {
            //是否绑定逻辑的判断
            Long acctId = accountUnionEntity.getAcctId();
            Long userId = accountUtils.getUserIdByAcctId(request.getProductType(), acctId.intValue());
            Account account = new Account();
            account.setId(userId);
            account.setAcctId(acctId.intValue());
            account.setCreatTime(new Date());
            account.setMobilePhone(request.getMobile());
            account.setRegisterSource(request.getSourceType());
            String newToken = tokenUtils.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(Constants.TOKEN, newToken);
            jsonObject.put(Constants.USER_ID, userId);
            jsonObject.put(Constants.BIND_FLAG, AccountTypeEnum.BIND_STATUS_SUCCESS.getCode());
            return jsonObject.toJSONString();
        } else {
            AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
            if (entity == null) {
                processWeChatInfoUser(weChatUserInfoEntity, request.getWeChatLoginType());
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(Constants.BIND_FLAG, AccountTypeEnum.BIND_STATUS_FAILURE.getCode());
            jsonObject.put(Constants.UNION_ID, unionId);
            return jsonObject.toJSONString();
        }
    }

    @Override
    public String loginByWeChatStep(BaseRequest request) {
        //判断当前手机号是否注册过,注册过，直接登录；没有注册过，进行注册操操作
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(request.getMobile()));
        String json;
        if (accountInfoEntity == null) {
            json = registerService.register(request);
            if (doubleWritingMode) {
                //双写模式下,要在doctor表存储unionId
                JSONObject jsonObject = JSONObject.parseObject(json);
                if (jsonObject.containsKey("userId")) {
                    Integer userId = jsonObject.getInteger("userId");
                    Doctor doctor = new Doctor();
                    doctor.setId(userId);
                    doctor.setUnionid(request.getUnionId());
                    doctorInfoMapper.updateByPrimaryKeySelective(doctor);
                }
            }
        } else {
            json = processLogin(request, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_WE_CHAT.getCode());
        }
        AccountInfoEntity accountInfo = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(request.getMobile()));
        Integer acctId = accountInfo.getId();
        processAccountUnion(acctId, request.getUnionId());
        return json;
    }

    @Override
    public void unbindWeChat(Integer acctId) {
        accountUnionMapper.updateUnbindByAcctId(acctId);
    }

    @Override
    public void bindWeChat(BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());
        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
        if (entity == null) {
            processWeChatInfoUser(weChatUserInfoEntity, request.getWeChatLoginType());
        }
        processAccountUnion(request.getAccId(), unionId);
    }

    /**
     * 把unionId存储到联合登录表中
     *
     * @param acctId
     * @param unionId
     */
    private void processAccountUnion(Integer acctId, String unionId) {
        AccountUnionEntity accountUnionEntity = new AccountUnionEntity();
        accountUnionEntity.setAcctId(acctId.longValue());
        accountUnionEntity.setDeleteFlag(1);
        accountUnionEntity.setUnionId(unionId);
        accountUnionEntity.setCreatedTime(new Date());
        accountUnionEntity.setModifiedTime(new Date());
        accountUnionEntity.setCreatedId(acctId);
        accountUnionEntity.setModifiedId(acctId);
        accountUnionEntity.setUnionType(AccountTypeEnum.UNION_LOGIN_WE_CHAT.getCode());
        accountUnionMapper.insertSelective(accountUnionEntity);
    }

    private void processWeChatInfoUser(WeChatUserInfoEntity weChatUserInfoEntity, int type) {
        AccountWeChatInfoEntity accountWeChatInfoEntity = new AccountWeChatInfoEntity();
        Date currentTime = new Date();
        accountWeChatInfoEntity.setCreatedId(0);
        accountWeChatInfoEntity.setCreatedTime(currentTime);
        accountWeChatInfoEntity.setDeleteFlag(1);
        accountWeChatInfoEntity.setGroupid(weChatUserInfoEntity.getGroupid() + "");
        accountWeChatInfoEntity.setType(type);
        accountWeChatInfoEntity.setModifiedId(0);
        accountWeChatInfoEntity.setModifiedTime(currentTime);
        accountWeChatInfoEntity.setOpenid(weChatUserInfoEntity.getOpenid());
        accountWeChatInfoEntity.setUnionid(weChatUserInfoEntity.getUnionid());
        accountWeChatInfoEntity.setPrivilege(weChatUserInfoEntity.getPrivilege());
        accountWeChatInfoEntity.setRemark(weChatUserInfoEntity.getRemark());
        accountWeChatInfoEntity.setSubscribe(weChatUserInfoEntity.getSubscribe());
        accountWeChatInfoEntity.setSubscribeTime(weChatUserInfoEntity.getSubscribe_time());
        accountWeChatInfoEntity.setTagidList(weChatUserInfoEntity.getTagid_list());
        accountWeChatInfoEntity.setCity(weChatUserInfoEntity.getCity());
        accountWeChatInfoEntity.setNickname(weChatUserInfoEntity.getNickname());
        accountWeChatInfoEntity.setHeadImgUrl(weChatUserInfoEntity.getHeadimgurl());
        accountWeChatInfoEntity.setCountry(weChatUserInfoEntity.getCountry());
        accountWeChatInfoEntity.setSex(weChatUserInfoEntity.getSex());
        accountWeChatInfoEntity.setProvince(weChatUserInfoEntity.getProvince());
        accountWeChatInfoEntity.setLanguage(weChatUserInfoEntity.getLanguage());
        accountWeChatInfoMapper.insertSelective(accountWeChatInfoEntity);
    }
}
