package com.pica.cloud.account.account.server.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.internal.SignUtils;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.*;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.req.QueryMobileReq;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.HttpUtil;
import com.pica.cloud.account.account.server.util.MD5;
import com.pica.cloud.account.account.server.util.RSAUtil;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.account.account.server.util.WeChatUtils;
import com.pica.cloud.account.account.server.vo.OneClickLoginResultVo;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.HttpClientUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import static com.pica.cloud.account.account.server.util.AESUtil.privateKey;

@Service
public class LoginServiceImpl implements LoginService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUnionMapper accountUnionMapper;

    @Autowired
    private AccountWeChatInfoMapper accountWeChatInfoMapper;

    @Autowired
    private AccountPatientInfoMapper accountPatientInfoMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private RegisterService registerService;

    @Autowired
    private DoctorMapper doctorInfoMapper;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private DoctorService doctorService;

    @Autowired

    private ICacheClient redisClient;

    @Value("${doubleWritingMode}")
    private boolean doubleWritingMode;

    @Value("${weChatAppID}")
    private String appId;
    @Value("${weChatAppSecret}")
    private String appSecret;
    @Value("${weChatURL}")
    private String weChatURL;

    private static final String DEFAULT_DOCTOR_PICTURE_URL = "/File/doctor_default.png";
    public static Map<String, String> PIC_TYPE_MAP = new HashMap();
    // 免密登录后台url
    public static final String FLASH_LOGIN_URL = "https://api.253.com/open/flashsdk/mobile-query";

    //创建应用时填入的rsa公钥对应的私钥字符串
    public static final String privateKey = "";
    static {
        PIC_TYPE_MAP.put("jpg", "FFD8FF");
        PIC_TYPE_MAP.put("jpeg", "FFD8FF");
        PIC_TYPE_MAP.put("png", "89504E47");
        PIC_TYPE_MAP.put("gif", "47494638");
        PIC_TYPE_MAP.put("bmp", "424D");
        PIC_TYPE_MAP.put("png", "89504E470D0a1a0a0000");
        PIC_TYPE_MAP.put("bmp", "424d228c010000000000");
        PIC_TYPE_MAP.put("bmp", "424d8240090000000000");
        PIC_TYPE_MAP.put("bmp", "424d8e1b030000000000");
    }

    @Override
    public LoginResult login(BaseRequest request) {
        String mobile = request.getMobile();
        String encrypt = AESUtil.encryptV0(mobile);
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(encrypt);
        if (accountInfoEntity != null) {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            if (password.equals(oldPwd)) {
                Date currentTime = new Date();
                Integer acctId = accountInfoEntity.getId();
                int productType = request.getProductType();
                int sourceType = request.getSourceType();
                Doctor doctorInfo=doctorInfoMapper.getDoctorInfoByMobile(encrypt);
                Integer userId = 0;
                if (productType == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
                    userId = doctorInfo.getId();
                } else if (productType == AccountTypeEnum.PRODUCT_TYPE_HEALTH.getCode()) {
                    AccountPatientInfoEntity accountPatientInfoEntity = accountPatientInfoMapper.selectByAcctId(acctId);
                    userId = accountPatientInfoEntity.getId();
                }
                Account account = new Account();
                account.setId(userId.longValue());
                account.setAcctId(acctId);
                account.setCreatTime(currentTime);
                account.setMobilePhone(mobile);
                account.setRegisterSource(sourceType);
                String newToken = tokenUtils.generateToken(account);
                LoginResult result = new LoginResult();
                result.setToken(newToken);
                result.setUserId(userId.longValue());
                result.setMobile(mobile);
                result.setDoctorId(EncryptUtils.encryptContent(userId+"", EncryptConstants.ENCRYPT_TYPE_ID));
                if (productType == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
                    result.setEntireFlag(doctorInfo.getEntireFlag());
                }

                LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, sourceType,
                        AccountTypeEnum.LOGIN_PWD.getCode(), request.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(),
                        AccountTypeEnum.LOG_TYPE_LOGIN.getCode());
                picaLogUtils.info(entity);

                return result;
            } else {
                logger.info("login failure：" + mobile);
                throw new PicaException(AccountExceptionEnum.PICA_PASSWORD_ERROR.getCode(), AccountExceptionEnum.PICA_PASSWORD_ERROR.getMessage());
            }
        } else {
            throw new PicaException(AccountExceptionEnum.PICA_NOT_REGISTER.getCode(), AccountExceptionEnum.PICA_NOT_REGISTER.getMessage());
        }
    }

    @Override
    public LoginResult loginAndRegister(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(mobile));
        if (accountInfoEntity == null) {
            //说明是注册功能
            accountUtils.checkRegisterMobilePhoneAndAuthCode(baseRequest.getMobile(),baseRequest.getFlag()+"",baseRequest.getAuthCode());
            return registerService.register(baseRequest);
        } else {
            //登录功能
            accountUtils.checkMobilePhoneAndAuthCode(baseRequest.getMobile(), AccountTypeEnum.SYSCODE_TYPE_LOGIN.getCode() + "", baseRequest.getAuthCode());
            return processLogin(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_CODE.getCode());
        }
    }

    /**
     * 登录逻辑处理
     *
     * @param baseRequest
     */
    private LoginResult processLogin(BaseRequest baseRequest, Integer acctId, Integer loginType) {
        Date currentTime = new Date();
        Long userId = accountUtils.getUserIdByAcctId(baseRequest.getProductType(), acctId);
        Account account = new Account();
        account.setId(userId);
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(baseRequest.getMobile());
        account.setRegisterSource(baseRequest.getSourceType());
        String newToken = tokenUtils.generateToken(account);
        LoginResult result = new LoginResult();
        result.setToken(newToken);
        result.setUserId(userId);
        result.setMobile(baseRequest.getMobile());
        result.setDoctorId(EncryptUtils.encryptContent(userId+"", EncryptConstants.ENCRYPT_TYPE_ID));
        //是否完善过个人信息（云鹊医app才需要）
        if (baseRequest.getProductType() == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
            Doctor doctorEntity = doctorInfoMapper.selectByPrimaryKey(userId.intValue());
            result.setEntireFlag(doctorEntity.getEntireFlag());
        }
        //记录登录日志
        LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, baseRequest.getProductType(), baseRequest.getSourceType(),
                loginType, baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode());
        picaLogUtils.info(entity);
        return result;
    }


    @Override
    @Transactional
    public LoginResult loginByWeChat(BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        if (weChatEntity == null || StringUtils.isEmpty(weChatEntity.getOpenid()) || StringUtils.isEmpty(weChatEntity.getAccess_token())) {
            throw new PicaException(AccountExceptionEnum.PICA_WECHAT_CODE_ERROR.getCode(), AccountExceptionEnum.PICA_WECHAT_CODE_ERROR.getMessage());
        }
        //todo：微信登录获取个人信息
        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());
        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountUnionEntity accountUnionEntity = accountUnionMapper.selectByUnionId(unionId);
        //是否绑定逻辑的判断
        if (accountUnionEntity != null) {
            Long acctId = accountUnionEntity.getAcctId();
            Long userId = accountUtils.getUserIdByAcctId(request.getProductType(), acctId.intValue());
            Account account = new Account();
            account.setId(userId);
            account.setAcctId(acctId.intValue());
            account.setCreatTime(new Date());
            //account.setMobilePhone(request.getMobile());
            account.setMobilePhone("");
            account.setRegisterSource(request.getSourceType());
            String newToken = tokenUtils.generateToken(account);
            LoginResult result = new LoginResult();
            result.setToken(newToken);
            result.setUserId(userId);
            result.setBindFlag(AccountTypeEnum.BIND_STATUS_SUCCESS.getCode()+"");
            result.setDoctorId(EncryptUtils.encryptContent(userId+"", EncryptConstants.ENCRYPT_TYPE_ID));
            if (request.getProductType() == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
                PICAPDoctor doctor = doctorInfoMapper.queryDoctor(userId);
                result.setEntireFlag(doctor.getEntire_flag());
                result.setMobile(AESUtil.decryptV0(doctor.getMobile_phone()));
            }
            return result;
        } else {
            AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
            //如果微信信息表数据不存在，就把用户信息存储到微信信息表中。
            if (entity == null) {
                processWeChatInfoUser(weChatUserInfoEntity, request.getWeChatLoginType());
            }
            LoginResult result = new LoginResult();
            result.setUnionId(unionId);
            result.setBindFlag(AccountTypeEnum.BIND_STATUS_FAILURE.getCode()+"");
            return result;
        }
    }

    @Override
    public LoginResult loginByWeChatStep(BaseRequest request) {
        //判断当前手机号是否注册过,注册过，直接登录；没有注册过，进行注册操操作
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(request.getMobile()));
        LoginResult result;
        if (accountInfoEntity == null) {
            result = registerService.register(request);
            if (doubleWritingMode) {
                //双写模式下,要在doctor表存储unionId
                if (result.getUserId()!=null) {
                    Doctor doctor = new Doctor();
                    doctor.setId(result.getUserId().intValue());
                    doctor.setUnionid(request.getUnionId());
                    doctorInfoMapper.updateByPrimaryKeySelective(doctor);
                }
            }
        } else {
            result = processLogin(request, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_WE_CHAT.getCode());
        }
        result.setMobile(request.getMobile());
        AccountInfoEntity accountInfo = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(request.getMobile()));
        Integer acctId = accountInfo.getId();
        processAccountUnion(acctId, request.getUnionId(),request.getProductType());
        return result;
    }

    @Override
    @Transactional
    public void unbindWeChat(long doctorId) {
        Integer acctId = doctorInfoMapper.getAcctIdByDoctorId(doctorId);
        accountUnionMapper.updateUnbindByAcctId(acctId);
        if (doubleWritingMode) {
            doctorService.unbindWeChat(acctId);
        }
    }

    @Override
    @Transactional
    public String bindWeChat(long doctorId, BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());
        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
        if (entity == null) {
            processWeChatInfoUser(weChatUserInfoEntity, request.getWeChatLoginType());
        } else {
            updateWechatInfoUser(entity, weChatUserInfoEntity);
        }
        Integer acctId = doctorInfoMapper.getAcctIdByDoctorId(doctorId);
        processAccountUnion(acctId, unionId,request.getProductType());
        return weChatUserInfoEntity.getNickname();
    }

    /**
     * 把unionId存储到联合登录表中
     *
     * @param acctId
     * @param unionId
     */
    private void processAccountUnion(Integer acctId, String unionId,Integer productType) {
        //先查询当前产品线是否有记录？如果有就更新成delete_flag=2; 然后在插入新的绑定记录
        AccountUnionEntity accountUnionResult = accountUnionMapper.selectByUnionId(unionId);
        if (accountUnionResult!=null){
            throw new PicaException(AccountExceptionEnum.PICA_WECHAT_UNBIND.getCode(), AccountExceptionEnum.PICA_WECHAT_UNBIND.getMessage());
        }
        AccountUnionEntity accountUnionEntityAccount = accountUnionMapper.selectByAcctId(acctId);
        if (accountUnionEntityAccount!=null){
            throw new PicaException(AccountExceptionEnum.PICA_WECHAT_BIND_OTHER.getCode(), AccountExceptionEnum.PICA_WECHAT_BIND_OTHER.getMessage());
        }
        AccountUnionEntity accountUnionEntity = new AccountUnionEntity();
        accountUnionEntity.setAcctId(acctId.longValue());
        accountUnionEntity.setDeleteFlag(1);
        accountUnionEntity.setUnionId(unionId);
        accountUnionEntity.setCreatedTime(new Date());
        accountUnionEntity.setModifiedTime(new Date());
        accountUnionEntity.setCreatedId(acctId);
        accountUnionEntity.setModifiedId(acctId);
        accountUnionEntity.setUnionType(AccountTypeEnum.UNION_LOGIN_WE_CHAT.getCode());
        accountUnionMapper.insertSelective(accountUnionEntity);
        if (doubleWritingMode) {  //双写模式
            doctorService.bindWeChat(acctId, unionId);
        }
    }

    private void processWeChatInfoUser(WeChatUserInfoEntity weChatUserInfoEntity, int type) {
        AccountWeChatInfoEntity accountWeChatInfoEntity = new AccountWeChatInfoEntity();
        Date currentTime = new Date();
        accountWeChatInfoEntity.setCreatedId(0);
        accountWeChatInfoEntity.setCreatedTime(currentTime);
        accountWeChatInfoEntity.setDeleteFlag(1);
        accountWeChatInfoEntity.setGroupid(weChatUserInfoEntity.getGroupid() + "");
        accountWeChatInfoEntity.setType(type);
        accountWeChatInfoEntity.setModifiedId(0);
        accountWeChatInfoEntity.setModifiedTime(currentTime);
        accountWeChatInfoEntity.setOpenid(weChatUserInfoEntity.getOpenid());
        accountWeChatInfoEntity.setUnionid(weChatUserInfoEntity.getUnionid());
        accountWeChatInfoEntity.setPrivilege(weChatUserInfoEntity.getPrivilege());
        accountWeChatInfoEntity.setRemark(weChatUserInfoEntity.getRemark());
        accountWeChatInfoEntity.setSubscribe(weChatUserInfoEntity.getSubscribe());
        accountWeChatInfoEntity.setSubscribeTime(weChatUserInfoEntity.getSubscribe_time());
        accountWeChatInfoEntity.setTagidList(weChatUserInfoEntity.getTagid_list());
        accountWeChatInfoEntity.setCity(weChatUserInfoEntity.getCity());
        accountWeChatInfoEntity.setNickname(weChatUserInfoEntity.getNickname());
        accountWeChatInfoEntity.setHeadImgUrl(weChatUserInfoEntity.getHeadimgurl());
        accountWeChatInfoEntity.setCountry(weChatUserInfoEntity.getCountry());
        accountWeChatInfoEntity.setSex(weChatUserInfoEntity.getSex());
        accountWeChatInfoEntity.setProvince(weChatUserInfoEntity.getProvince());
        accountWeChatInfoEntity.setLanguage(weChatUserInfoEntity.getLanguage());
        accountWeChatInfoMapper.insertSelective(accountWeChatInfoEntity);
    }

    private void updateWechatInfoUser(AccountWeChatInfoEntity entity, WeChatUserInfoEntity weChatUserInfoEntity) {
        String nickname = weChatUserInfoEntity.getNickname();
        if (StringUtils.isNotEmpty(nickname) && !nickname.equals(entity.getNickname())) {
            AccountWeChatInfoEntity info = new AccountWeChatInfoEntity();
            info.setId(entity.getId());
            info.setNickname(nickname);
            accountWeChatInfoMapper.updateByPrimaryKeySelective(info);
        }
    }

    public PICAPDoctor queryDoctor(long doctorId) {
        PICAPDoctor doctor = doctorInfoMapper.queryDoctor(doctorId);
        if (doctor == null) {
            doctor = new PICAPDoctor();
        }
        doctor.setAvatar_image_url(this.processDoctorAvatar(doctor.getAvatar_image_url()));
        return doctor;
    }

    @Override
    public OneClickLoginResultVo oneClickLogin(OneClickLoginReq req) {
        OneClickLoginResultVo o = new OneClickLoginResultVo();
        //应用对应的闪验APPID
        String appId = "";
        //应用对应的闪验APPKEY
        String appKey = "";
        if(0 == req.getType()){
            appId = "BQwEYJht";
            appKey = "6KizWzXr";
        }else{
            appId = "XcdiWema";
            appKey = "psIOYIa4";
        }
        //手机号加解密方式 0 AES 1 RSA , 可以不传，不传则手机号解密直接使用AES解密
        String encryptType = "0";
        //从SDK获取的token参数
        String token = req.getToken();
        try {
            Map<String, String> params = new HashMap<String, String>();
            params.put("token", token);
            params.put("appId", appId);
            params.put("encryptType", encryptType);//可以不传，不传则解密直接使用AES解密
            params.put("sign", com.pica.cloud.account.account.server.util.SignUtils.getSign(params, appKey));
            QueryMobileEntity queryMobileEntity = (QueryMobileEntity) HttpUtil.postForm(FLASH_LOGIN_URL,params,QueryMobileEntity.class);
            if (null != queryMobileEntity) {
                System.out.println("response:" + queryMobileEntity);
                String code = queryMobileEntity.getCode();     //返回码 200000为成功
                String message = queryMobileEntity.getMessage();//返回消息
                Integer chargeStatus = queryMobileEntity.getChargeStatus(); //是否收费
                o.setQueryMobileEntity(queryMobileEntity);
                if ("200000".equals(code)) {
                    MobileDataEntity mobileDataEntity = queryMobileEntity.getData();
                    String mobile = mobileDataEntity.getMobileName();
                    if ("0".equals(encryptType)) {
                        String key = MD5.getMD5Code(appKey);
                        mobile = AESUtil.decrypt(mobile, key.substring(0, 16), key.substring(16));
                    } else if ("1".equals(encryptType)) {
                        mobile = RSAUtil.decryptByPrivateKeyForLongStr(mobile, privateKey);
                    }
                    System.out.println("mobile:" + mobile); //解密后的手机号码
                    queryMobileEntity.getData().setMobileName(mobile);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    public static void main(String[] args) {
        LoginServiceImpl l = new LoginServiceImpl();
        OneClickLoginReq req = new OneClickLoginReq();
        l.oneClickLogin(req);
    }

    private String processDoctorAvatar(String avatar_image_url) {
        if (StringUtils.isEmpty(avatar_image_url)) {
            return DEFAULT_DOCTOR_PICTURE_URL;
        } else {
            int pos = avatar_image_url.lastIndexOf(".");
            if (pos < 0) {
                return DEFAULT_DOCTOR_PICTURE_URL;
            } else {
                String ext = avatar_image_url.substring(pos + 1, avatar_image_url.length()).toLowerCase();
                return !PIC_TYPE_MAP.containsKey(ext) ? DEFAULT_DOCTOR_PICTURE_URL : avatar_image_url;
            }
        }
    }


}
