package com.pica.cloud.account.account.server.util;

import com.pica.cloud.account.account.server.entity.WeChatEntity;
import com.pica.cloud.foundation.utils.constants.WeChatConstants;
import com.pica.cloud.foundation.utils.utils.JsonUtil;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.foundation.utils.utils.date.DateTimeUtils;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.Date;

//import com.picahealth.common.utils.DateTimeUtils;
//import com.picahealth.common.utils.JsonUtil;
//import com.picahealth.common.utils.StringUtil;
//import com.picahealth.wit.wechat.constants.WeChatConstants;
//import com.picahealth.wit.wechat.entity.AccessToken;
//import com.picahealth.wit.wechat.entity.JsapiTicket;
//import com.picahealth.wit.wechat.entity.Menu;

//import static com.picahealth.wechat.wechat.thread.AccessTokenThread.appid;
//import static com.picahealth.wechat.wechat.thread.AccessTokenThread.appsecret;

//import static com.picahealth.wechat.wechat.thread.AccessTokenThread.appid;
//import static com.picahealth.wechat.wechat.thread.AccessTokenThread.appsecret;
//import static com.picahealth.wechat.wechat.thread.AccessTokenThread.jsapiTicket;

/**
 * 公众平台通用接口工具类
 *
 * @author bo.dang
 * @date 2013-08-09
 */
public class WeChatToolUtil {
	private static Logger logger = LoggerFactory.getLogger(WeChatToolUtil.class);
	/** access_token */
	public static String access_token;

	public static WeChatEntity accessToken;
	/** 获取access_token的时间 */
	private static Date get_access_token_time;


	/**
	 * 发起https请求并获取结果
	 *
	 * @param requestUrl 请求地址
	 * @param requestMethod 请求方式（GET、POST）
	 * @param outputStr 提交的数据
	 * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
	 */
	public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
		JSONObject jsonObject = null;
		StringBuffer buffer = new StringBuffer();
		try {
			// 创建SSLContext对象，并使用我们指定的信任管理器初始化
			TrustManager[] tm = { new MyX509TrustManager() };
			SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
			sslContext.init(null, tm, new java.security.SecureRandom());
			// 从上述SSLContext对象中得到SSLSocketFactory对象
			SSLSocketFactory ssf = sslContext.getSocketFactory();

			URL url = new URL(requestUrl);
			HttpsURLConnection httpUrlConn = (HttpsURLConnection) url.openConnection();
			httpUrlConn.setSSLSocketFactory(ssf);

			httpUrlConn.setDoOutput(true);
			httpUrlConn.setDoInput(true);
			httpUrlConn.setUseCaches(false);
			// 设置请求方式（GET/POST）
			httpUrlConn.setRequestMethod(requestMethod);

			if ("GET".equalsIgnoreCase(requestMethod))
				httpUrlConn.connect();

			// 当有数据需要提交时
			if (null != outputStr) {
				OutputStream outputStream = httpUrlConn.getOutputStream();
				// 注意编码格式，防止中文乱码
				outputStream.write(outputStr.getBytes("UTF-8"));
				outputStream.close();
			}

			// 将返回的输入流转换成字符串
			InputStream inputStream = httpUrlConn.getInputStream();
			InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
			BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

			String str = null;
			while ((str = bufferedReader.readLine()) != null) {
				buffer.append(str);
			}
			bufferedReader.close();
			inputStreamReader.close();
			// 释放资源
			inputStream.close();
			inputStream = null;
			httpUrlConn.disconnect();
			logger.info(buffer.toString());
			jsonObject = JSONObject.fromObject(buffer.toString());
		} catch (ConnectException ce) {
			logger.error("Weixin server connection timed out.");
		} catch (Exception e) {
			logger.error("https request error:{}", e);
		}
		return jsonObject;
	}


	/**
	 * 获取access_token
	 *
	 * @param appid 凭证
	 * @param appsecret 密钥
	 * @return
	 */
	public static WeChatEntity getAccessToken(String appid, String appsecret) {
		WeChatEntity accessToken = null;

		String requestUrl = WeChatConstants.ACCESS_TOKEN_URL.replace("APPID", appid).replace("APPSECRET", appsecret);
		JSONObject jsonObject = httpRequest(requestUrl, "GET", null);
		// 如果请求成功
		if (null != jsonObject) {
			try {
				access_token = jsonObject.getString("access_token");
				if(!StringUtil.isEmpty(access_token)){
					get_access_token_time = new Date();
					accessToken = JsonUtil.toGsonBean(jsonObject.toString(), WeChatEntity.class);
/*
					accessToken.setAccess_token(jsonObject.getString("access_token"));
					accessToken.setExpires_in(jsonObject.getInt("expires_in"));*/
				}
				else {
					get_access_token_time = new Date();
				}
			} catch (JSONException e) {
				accessToken = null;
				// 获取token失败
				logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
			}
		}
		else {
			// 获取token失败
			logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));

		}

		WeChatToolUtil.accessToken = accessToken;

		return accessToken;
	}


	/**
	 * 校验accessToken是否过期
	 * @param access_token
	 * @return
     */
//	public static WeChatEntity checkAccessTokencheckAccessToken(String access_token){
//
//
//		WeChatEntity accessToken = WeChatToolUtil.accessToken;
//
//		if(WeChatToolUtil.isExpired() || StringUtil.isEmpty(access_token)){
//
//			accessToken = WeChatToolUtil.getAccessToken(appId, WeChatConstants.APP_SECRET);
//		}
//
//
//		return accessToken;
//
//	}


//	/**
//	 * 获得jsapi_ticket
//	 * @return
//	 */
//    public static JsapiTicket getJsapi_ticket(){
//
//    	//AccessToken accessToken = getAccessToken(WeChatConstants.APP_ID, WeChatConstants.APP_SECRET);
//
//		String requestUrl = WeChatConstants.GET_JSAPI_TICKET.replace("ACCESS_TOKEN", access_token);
//		JSONObject jsonObject = httpRequest(requestUrl, "GET", null);
//		JsapiTicket jsapiTicket = null;
//		if(StringUtil.isNotNull(jsonObject)){
//			jsapiTicket = JsonUtil.toGsonBean(jsonObject.toString(), JsapiTicket.class);
//		}
//
//    	return jsapiTicket;
//
//    }
//
//    /**
//     * 签名算法
//     * @param url
//     * @return
//     */
//    public static Map<String, String> sign(String url){
//    	//String jsapi_ticket = getJsapi_ticket();
//    	return Sign.sign(jsapiTicket.getTicket(), url);
//    }
//
//	/**
//	 * 创建菜单
//	 *
//	 * @param menu 菜单实例
//	 * @param accessToken 有效的access_token
//	 * @return 0表示成功，其他值表示失败
//	 */
//	public static int createMenu(Menu menu, String accessToken) {
//		int result = 0;
//
//		// 拼装创建菜单的url
//		String url = WeChatConstants.MENU_CREATE_URL.replace("ACCESS_TOKEN", accessToken);
//		// 将菜单对象转换成json字符串
//		String jsonMenu = JSONObject.fromObject(menu).toString();
//		// 调用接口创建菜单
//		JSONObject jsonObject = httpRequest(url, "POST", jsonMenu);
//
//		if (null != jsonObject) {
//			if (0 != jsonObject.getInt("errcode")) {
//				result = jsonObject.getInt("errcode");
//				logger.error("创建菜单失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
//			}
//		}
//
//		return result;
//	}

//	/**
//	 * 设置所属行业
//	 *
//	 * @param menu 菜单实例
//	 * @param accessToken 有效的access_token
//	 * @return 0表示成功，其他值表示失败
//	 */
//	public static int setIndustry(, String accessToken) {
//		int result = 0;
//
//		// 拼装创建菜单的url
//		String url = WeChatConstants.MENU_CREATE_URL.replace("ACCESS_TOKEN", accessToken);
//		// 将菜单对象转换成json字符串
//		String jsonMenu = JSONObject.fromObject(menu).toString();
//		// 调用接口创建菜单
//		JSONObject jsonObject = httpRequest(url, "POST", jsonMenu);
//
//		if (null != jsonObject) {
//			if (0 != jsonObject.getInt("errcode")) {
//				result = jsonObject.getInt("errcode");
//				logger.error("创建菜单失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
//			}
//		}
//
//		return result;
//	}


	/**
	 * 判断是否是QQ表情
	 *
	 * @param content
	 * @return
	 */
//	public static boolean isQqFace(String content) {
//		boolean result = false;
//
//		// 判断QQ表情的正则表达式
//		String qqfaceRegex = "/::\\)|/::~|/::B|/::\\||/:8-\\)|/::<|/::$|/::X|/::Z|/::'\\(|/::-\\||/::@|/::P|/::D|/::O|/::\\(|/::\\+|/:--b|/::Q|/::T|/:,@P|/:,@-D|/::d|/:,@o|/::g|/:\\|-\\)|/::!|/::L|/::>|/::,@|/:,@f|/::-S|/:\\?|/:,@x|/:,@@|/::8|/:,@!|/:!!!|/:xx|/:bye|/:wipe|/:dig|/:handclap|/:&-\\(|/:B-\\)|/:<@|/:@>|/::-O|/:>-\\||/:P-\\(|/::'\\||/:X-\\)|/::\\*|/:@x|/:8\\*|/:pd|/:<W>|/:beer|/:basketb|/:oo|/:coffee|/:eat|/:pig|/:rose|/:fade|/:showlove|/:heart|/:break|/:cake|/:li|/:bome|/:kn|/:footb|/:ladybug|/:shit|/:moon|/:sun|/:gift|/:hug|/:strong|/:weak|/:share|/:v|/:@\\)|/:jj|/:@@|/:bad|/:lvu|/:no|/:ok|/:love|/:<L>|/:jump|/:shake|/:<O>|/:circle|/:kotow|/:turn|/:skip|/:oY|/:#-0|/:hiphot|/:kiss|/:<&|/:&>";
//		Pattern p = Pattern.compile(qqfaceRegex);
//		Matcher m = p.matcher(content);
//		if (m.matches()) {
//			result = true;
//		}
//		return result;
//	}

	/**
	 * 判断access_token是否过期
	 */
	public static Boolean isExpired(){
		if(null != get_access_token_time){
			logger.info("判断access_token是否过期 get_access_token_time:{} currentTime:{}", DateTimeUtils.DateTimeFormater.format(get_access_token_time), DateTimeUtils.currentDateTime());
			return DateTimeUtils.compare2Date(new Date(), DateTimeUtils.addDateSeconds(get_access_token_time, (7200-60) * 1000));
		}
		else {
			return true;
		}
	}


//	/**
//	 * 判断access_token是否过期
//	 */
//	public static Boolean isExpired(Date createdAt, Integer expireIn){
//		if(null != createdAt){
//			logger.info("判断access_token是否过期 createdAt time:{} currentTime:{}", DateTimeUtils.DateTimeFormater.format(createdAt), DateTimeUtils.currentDateTime());
//			return DateTimeUtils.compare2Date(new Date(), DateTimeUtils.addDateSeconds(createdAt, (expireIn - 60) * 1000));
//		}
//		else {
//			return true;
//		}
//	}


	/**
	 * 系统启动时取得AccessToken
	 * @return
     */
//	public static WeChatEntity initWechatAccessToken(String appid, String appsecret){
//
//		accessToken = WeChatToolUtil.getAccessToken(appid, appsecret);
//		if (null != accessToken) {
//			logger.info("获取access_token成功，有效时长{}秒 access_token:{}", accessToken.getExpires_in(), accessToken.getAccess_token());
//			// 获取权限签名
//			jsapiTicket = WeChatToolUtil.getJsapi_ticket();
//			if (StringUtil.isNotNull(jsapiTicket)) {
//				logger.info("获取jsapi_ticket成功，有效时长{}秒 jsapi_ticket:{}", jsapiTicket.getExpires_in(), jsapiTicket.getTicket());
//			}
//		}
//
//	   return accessToken;
//	}


/*	// 文本消息
	if (msgType.equals(MessageUtil.REQ_MESSAGE_TYPE_TEXT)) {
		// 文本消息内容
		String content = requestMap.get("Content");

		// 判断用户发送的是否是单个QQ表情
		if(XiaoqUtil.isQqFace(content)) {
			// 回复文本消息
			TextMessage textMessage = new TextMessage();
			textMessage.setToUserName(fromUserName);
			textMessage.setFromUserName(toUserName);
			textMessage.setCreateTime(new Date().getTime());
			textMessage.setMsgType(MessageUtil.RESP_MESSAGE_TYPE_TEXT);
			textMessage.setFuncFlag(0);
			// 用户发什么QQ表情，就返回什么QQ表情
			textMessage.setContent(content);

			// 将文本消息对象转换成xml字符串
			respMessage = MessageUtil.textMessageToXml(textMessage);
		}
	}*/
}