package com.pica.cloud.account.account.server.enums;

/**
 * Created on 2019/8/27
 * author:crs
 * Description:账户常用枚举类型
 */
public enum AccountTypeEnum {

    //登录类型枚举（记录登录日志时使用）
    LOGIN_CODE(1, "验证码登录"),
    LOGIN_PWD(2, "密码登录"),
    LOGIN_WE_CHAT(3, "微信登录"),
    LOGIN_OUT(4, "退出登录"),
    LOGIN_REGISTER(5, "注册登录"),
    LOGIN_APPLE(6, "Apple登录"),
    LOGIN_ONE_CLICK(7, "一键登录"),

    //登录态相关枚举
    LOGIN_STATUS_SUCCESS(1, "登录成功"),
    LOGIN_STATUS_FAILURE(2, "登录失败"),

    //产品来源相关枚举
    PRODUCT_TYPE_DOCTOR(1, "云鹊医产品系"),
    PRODUCT_TYPE_HEALTH(2, "云鹊健康产品系"),
    PRODUCT_TYPE_ECO_LIVE(3, "生态直播"),
    PRODUCT_TYPE_CRM(4, "销售crm"),


    //终端类型
    DEVICE_TYPE_ANDROID(1, "安卓"),
    DEVICE_TYPE_IOS(2, "ios"),
    DEVICE_TYPE_WEB(3, "web"),
    DEVICE_TYPE_H5(4, "H5"),
    DEVICE_TYPE_ADMIN(5, "admin"),
    DEVICE_TYPE_SAAS(6, "saas"),
    DEVICE_TYPE_SSO(7, "sso"),
    DEVICE_TYPE_CRM(8, "crm"),


    //验证码获取类型： flag：0登录（默认）1注册 2微信登录绑定手机 3修改手机 4重置密码
    //5忘记密码 7患者招募提交问卷(效验) 8Appe登录绑定手机
    SYSCODE_TYPE_LOGIN(0, "登录"),
    SYSCODE_TYPE_REGISTER(1, "注册"),
    SYSCODE_TYPE_WE_CHAT(2, "微信登录绑定手机"),
    SYSCODE_TYPE_MODIFY_MOBILE(3, "修改手机号"),
    SYSCODE_TYPE_RESET_PASSWORD(4, "重置密码"),
    SYSCODE_TYPE_FORGET_PASSWORD(5, "重置密码"),
    SYSCODE_TYPE_SMO_COMIIT_QUESTIONNAIRE(6, "患者招募提交问卷"),
    SYSCODE_TYPE_APPLE(8, "Appe登录绑定手机"),

    //联合登录类型
    UNION_LOGIN_WE_CHAT(1, "微信"),
    UNION_LOGIN_QQ(2, "QQ"),
    union_login_blog(3, "微博"),
    UNION_LOGIN_APPLE(4, "苹果"),

    //微信/apple绑定状态
    BIND_STATUS_SUCCESS(1, "已绑定"),
    BIND_STATUS_FAILURE(0, "未绑定"),

    //日志类型枚举
    LOG_TYPE_LOGIN(1, "登录日志"),
    LOG_TYPE_PASSWORD(2, "密码更新日志"),
    LOG_TYPE_USER_INFO(3, "用户信息更新日志");

    private int code;
    private String type;

    AccountTypeEnum(int code, String type) {
        this.code = code;
        this.type = type;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
