package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.configuration.PropertiesConfiguration;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.util.IntactUtil;
import com.pica.cloud.account.account.server.util.PICAPSendMsgModel;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.utils.constants.SysCode;
import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.HttpClientUtil;
import com.pica.cloud.foundation.utils.utils.MD5Util;
import com.pica.cloud.foundation.utils.utils.json.Object2Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * controller基类
 *
 * @author andong
 * @create 2019/5/21
 */
public abstract class AccountBaseController extends BaseController {


    private static final String KEY_PREFIX = "token-doctor-";
    private Logger logger = LoggerFactory.getLogger(AccountBaseController.class);
    @Autowired
    private PropertiesConfiguration configuration;

    @Autowired
    private IntactUtil intactUtil;

    //从token获取医生ID
    public long getDoctorIdByToken() {
        try {
            PicaUser picaUser = super.fetchPicaUser();
            return picaUser.getId().longValue();
        } catch (Exception ex) {
            throw new PicaException(PicaResultCode.LOGIN_FAILE);
        }
    }

    //获取deviceInfo信息
    public String getDeviceInfo(String key) {
        String deviceInfo = super.getDeviceInfo();
        if (StringUtils.isBlank(key) || StringUtils.isBlank(deviceInfo)) {
            return StringUtils.EMPTY;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject(deviceInfo);
            return jsonObject.getString(key);
        } catch (Exception ex) {
            return StringUtils.EMPTY;
        }
    }

    public String getDeviceInfoLow(String key) {
        String deviceInfo = this.getRequest().getHeader("deviceinfo");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(deviceInfo)) {
            return StringUtils.EMPTY;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject(deviceInfo);
            return jsonObject.toJSONString();
        } catch (Exception ex) {
            return StringUtils.EMPTY;
        }
    }

    //保存token，并返回token值(web或app，不包含h5)
    public String saveToken(String token, PicaUser picaUser) {
        if (StringUtils.isNotEmpty(token)) {
            picaUser.setToken(token);
        }

        String sysCode = super.getSysCode();
        if ("9".equals(sysCode)) {
            sysCode = "saas";
        } else if ("10".equals(sysCode)) {
            sysCode = "app";
        }

        String tokenValue = super.getRedisClient().get(KEY_PREFIX + picaUser.getId().toString() + "-" + sysCode);
        if (StringUtils.isNotBlank(tokenValue)) {
            return tokenValue.replace("token-", "");  //token已经存在则直接返回
        }

        try {
            Map<String, String> data = Object2Map.objectToMapString("yyyy-MM-dd HH:mm:ss", picaUser, new String[0]);
            data.put("sysCode", sysCode);
            return super.getRedisClient().saveToken(data, 365 * 24 * 3600);  //token有效期365天
        } catch (Exception ex) {
            logger.error("保存token失败，doctorId: {}", picaUser.getId());
            return StringUtils.EMPTY;
        }
    }

    //发送手机短信
    public void sendMobileMessage(String mobile, String content, long senderId) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "sendMobileMessage", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "mobile:" + mobile + ",content:" + content + ",senderId:" + senderId);
        String sysCodeStr = super.getSysCode();
        int sysCode = 10; //默认移动端
        if (StringUtils.isNotBlank(sysCodeStr)) {
            try {
                sysCode = Integer.parseInt(sysCodeStr);
            } catch (Exception ex) {
                logger.error(ex.getMessage(), ex);
            }
        }

        String messageUrl = configuration.getMessageUrl() + Constants.SEND_MESSAGE;
        PICAPSendMsgModel picapSendMsgModel = new PICAPSendMsgModel();
        picapSendMsgModel.setContent(content);
        picapSendMsgModel.setMobile(mobile);
        picapSendMsgModel.setUserId((int) senderId);
        ArrayList<String> params = new ArrayList();
        params.add("");
        params.add(String.valueOf(sysCode));
        picapSendMsgModel.setParams(params);
        picapSendMsgModel.setTmplId(17636);
        picapSendMsgModel.setSign("");
        picapSendMsgModel.setExt("");
        picapSendMsgModel.setExtend("");
        picapSendMsgModel.setSupplementFlag(true);
        picapSendMsgModel.setSms_entity_id(0);
        long currentTimeMillis = System.currentTimeMillis();
        picapSendMsgModel.setTime(String.valueOf(currentTimeMillis));
        picapSendMsgModel.setKey(MD5Util.MD5("pica" + currentTimeMillis));
        picapSendMsgModel.setSysCode(SysCode.APP.sysCode());
        picapSendMsgModel.setSysName(SysCode.APP.sysName());

        String postData = JSON.toJSONString(picapSendMsgModel);
        logger.info("sendMobileTo-mobile:{}, senderId-{}", mobile, senderId);
        long start = System.currentTimeMillis();
        String jsonObj = HttpClientUtil.httpExecute(messageUrl, postData);
        intactUtil.sendIntact(batchNo, "sendMobileMessage", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "jsonObj:" + jsonObj);

        long end1 = System.currentTimeMillis();
        logger.info("sendMobileMessage-send message used {} million seconds", end1 - start);
        logger.info("sendMobileTo-{}", jsonObj);

        if (StringUtils.isEmpty(jsonObj)) {
            logger.error("send message fail, response is empty");
            throw new PicaWarnException(AccountExceptionEnum.PICA_MESSAGE_SERVICE_CALL_FAIL.getCode(),
                    AccountExceptionEnum.PICA_MESSAGE_SERVICE_CALL_FAIL.getMessage());
        }
        try {
            PicaResponse resp = JSON.parseObject(jsonObj, PicaResponse.class);
            if (Objects.nonNull(resp) && PicaResultCode.SUCCESS.code().equals(resp.getCode())) {
                logger.info("send message success, the result is: {}", jsonObj);
            } else {
                logger.error("send message fail, response code not equals success code");
                throw new PicaWarnException(AccountExceptionEnum.PICA_MESSAGE_SERVICE_CALL_FAIL.getCode(),
                        AccountExceptionEnum.PICA_MESSAGE_SERVICE_CALL_FAIL.getMessage());
            }
        } catch (JSONException e) {
            logger.error("send message fail, response object is not a json object");
            throw new PicaWarnException(AccountExceptionEnum.PICA_MESSAGE_SERVICE_CALL_FAIL.getCode(),
                    AccountExceptionEnum.PICA_MESSAGE_SERVICE_CALL_FAIL.getMessage());
        }

    }

    /**
     * 账户信息
     *
     * @return
     */
    public AccountUser getAccountUser() {
        //把所有请求头信息都封装到当前模型中
        String token = this.getToken();
        AccountUser accountUser = super.getRedisClient().getToken(token, AccountUser.class);
        accountUser.setLoginFrom(this.getSourceType());
        accountUser.setLoginPlatform(this.getProductType());
        accountUser.setLoginIp(super.getIpAddr());
        accountUser.setUserTokenTourist(this.getUserTokenTourist());
        return accountUser;
    }

    /**
     * 获取账户id
     *
     * @return
     */
    public Integer getAcctId() {
        try {
            AccountUser accountUser = getAccountUser();
            return accountUser.getAcctId();
        } catch (Exception e) {
            e.printStackTrace();
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
    }

    /**
     * 产品线类型：productType： 1.云鹊医（默认值） 2.云鹊健康  3.直播 4.crm
     *
     * @return
     */
    public Integer getProductType() {
        HttpServletRequest request = super.getRequest();
        String str = request.getHeader("productType");
        if (StringUtils.isNotEmpty(str)) {
            return Integer.parseInt(str);
        }
        return null;
    }

    /**
     * 终端来源 sourceType:1.android  2.ios  3.web
     * 4.wechat(例如微信小程序)、H5 5.admin   6. saas
     *
     * @return
     */
    public Integer getSourceType() {
        HttpServletRequest request = super.getRequest();
        String str = request.getHeader("sourceType");
        if (StringUtils.isNotEmpty(str)) {
            return Integer.parseInt(str);
        }
        return null;
    }

    public String getUserTokenTourist() {
        HttpServletRequest request = super.getRequest();
        return request.getHeader("user_token_tourist");
    }
}
