package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.RSAUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created on 2019/9/16 15:29
 * author:crs
 * Description:H5端获取公钥资源
 */
@Api(description = "密钥接口资源")
@RestController
public class CipherController {

    @Value("${rsapublickey}")
    private String rsaPublicKey;

    @ApiOperation("获取公钥Key接口")
    @GetMapping(value = "/cipher/key")
    public PicaResponse<String> getPublicKey() {
        return PicaResponse.toResponse(rsaPublicKey);
    }


//    /**
//     *
//     * @param key
//     * @return
//     * @throws Exception
//     */
//    @ApiOperation("解密操作")
//    @GetMapping(value = "/cipher/decrypt")
//    public PicaResponse<String> decryptPublicKey(@RequestParam String key) throws Exception {
//        return PicaResponse.toResponse(RSAUtil.decrypt(key, AESUtil.privateKey));
//    }

}
