package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.ModifyMobileService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(description="修改手机号资源")
@RestController
public class ModifyMobileController extends AccountBaseController {

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private ModifyMobileService modifyMobileService;

    @ApiOperation("修改手机号")
    @PostMapping("/mobile/modify")
    public PicaResponse modifyMobile(@RequestBody EncryptEntity entity) throws Exception {
        Integer acctId = super.getAcctId();
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        String mobile = request.getMobile();
        accountUtils.checkMobilePhoneAndAuthCode(mobile, AccountTypeEnum.SYSCODE_TYPE_MODIFY_MOBILE.getCode() + "", request.getAuthCode());
        modifyMobileService.modify(acctId, mobile);
        return PicaResponse.toResponse();
    }
}
