package com.pica.cloud.account.account.server.queue;

import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * Created on 2019/9/11 17:27
 * author:crs
 * Description:消息队列配置
 */
@Configuration
public class QueueConfig {

    public final static String QUEUE_NAME = "register_queue_account_13201";
    public final static String EXCHANGE_NAME = "register_exchange";
    public final static String ROUTE_KEY_NAME = "register_finish";
    
    /**
     * 创建一个消息队列
     *
     * @return
     */
    @Bean
    public Queue queue() {
        return new Queue(QUEUE_NAME, true, false, true);
    }

    /**
     * 创建交换机
     *
     * @return
     */
    @Bean
    public TopicExchange directExchange() {
        return new TopicExchange(EXCHANGE_NAME);
    }

    /**
     * 把消息队里和交换机进行绑定
     *
     * @return
     */
    @Bean
    public Binding binding() {
        return BindingBuilder.bind(queue()).to(directExchange()).with(ROUTE_KEY_NAME);
    }
}
