package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.service.CaptchaService;
import com.pica.cloud.account.account.server.util.captcha.CaptchaGenerator;
import com.pica.cloud.account.account.server.util.captcha.CaptchaToken;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import java.util.UUID;

/**
 * @author Laurence Cao
 *
 */
@Component
public class CaptchaServiceImpl implements CaptchaService {

    private final int size = 5;
    private final int EXPIRE = 5 * 60; // 5 minutes
    private final String CAPTCHA_PREFIX = "captcha-";
    @Autowired
    private CaptchaGenerator agent;
    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Override
    public CaptchaToken generateToken(int width, int height) {
        String origin = agent.generateChars(size);
        byte[] buf = agent.createCaptcha(origin, width, height);
        CaptchaToken ret = new CaptchaToken();
        ret.setBuf(buf);
        ret.setOrigin(origin);
        ret.setToken(DigestUtils.md5Hex(UUID.randomUUID().toString()));
        redisClient.set(CAPTCHA_PREFIX + ret.getToken(), origin, EXPIRE);
        return ret;
    }

    @Override
    public boolean acknowledge(String token, String answer) {
        String origin = redisClient.get(CAPTCHA_PREFIX + token);
        redisClient.del(CAPTCHA_PREFIX + token);
        if (origin != null && answer != null) {
            return origin.compareToIgnoreCase(answer) == 0;
        }
        return false;
    }

}
