package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.common.req.AcctPatInfoReq;
import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;
import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.req.PatientReq;
import com.pica.cloud.account.account.server.service.PatientInfoService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(description = "云鹊健康用户信息资源")
@RestController
@RequestMapping(value = "/patient")
public class PatientInfoController extends AccountBaseController {

    @Autowired
    private PatientInfoService patientInfoService;

    /**
     * 获取用户信息接口,产品线不同，用户信息不同（云鹊医，云鹊健康）
     *
     * @return
     */
    @ApiOperation("获取居民信息")
    @GetMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse getUserInfo() {
        AccountUser accountUser = super.getAccountUser();
        AccountPatientInfoEntity userInfo = null;
        Integer loginFrom = accountUser.getLoginFrom();
        Integer userId = accountUser.getId();
        if (loginFrom == 2) {
            userInfo = patientInfoService.getUserInfo(userId);
        }
        return PicaResponse.toResponse(userInfo);
    }

    /**
     * 修改用户信息接口
     *
     * @return
     */
    @ApiOperation("修改居民信息")
    @PutMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse putUserInfo(@RequestBody EncryptEntity entity) throws Exception {
        Integer id = super.getAccountUser().getId();
        PatientReq request = CryptoUtil.decrypt(entity, PatientReq.class);
        request.setId(id);
        request.setAcctId(super.getAcctId());
        AccountPatientInfoEntity accountPatientInfoEntity = new AccountPatientInfoEntity();
        BeanUtils.copyProperties(accountPatientInfoEntity, request);
        patientInfoService.updateUserInfo(accountPatientInfoEntity);
        return PicaResponse.toResponse();
    }

    /**
     * 修改用户信息接口
     *
     * @return
     */
    @ApiOperation("修改居民信息")
    @PostMapping(value = "/acct/info", produces = "application/json;charset=utf-8")
    public PicaResponse postUserInfo(@RequestBody AcctPatInfoReq infoReq) throws Exception {
        patientInfoService.updateUserInfoV2(infoReq);
        return PicaResponse.toResponse();
    }

    @ApiOperation("客服系统添加居民信息")
    @PostMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse addPatientInfo(AccountPatientInfoEntity entity) {
        Integer userId = super.getAccountUser().getId();
        AccountUtils.checkMobilePhone(entity.getMobilePhone());
        if (StringUtils.isBlank(entity.getName())) {
            patientInfoService.addPatientInfo(entity, userId);
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_PARAMS_ERROR);
        }
        return PicaResponse.toResponse();
    }

    @ApiOperation("客服系统添加居民信息")
    @GetMapping(value = "/unionId/{patientId}", produces = "application/json;charset=utf-8")
    public PicaResponse<String> getUnionIdByPatientId(@PathVariable("patientId") Integer patientId) {
        return PicaResponse.toResponse(patientInfoService.getUnionIdByPatientId(patientId));
    }
}
