package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.common.req.OCINRequest;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.*;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.ExecutorServiceUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.concurrent.ExecutorService;

@Service
public class RegisterServiceImpl implements RegisterService {

    private final String REPEAT_REGISTER_PREFIX = "repeat-register—";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PUserRoleMapper pUserRoleMapper;

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountPatientInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountMapper accountMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private TokenUtils tokenUtils;

//    @Autowired
//    private QueueProducer queueProducer;

    @Autowired
    private AgreementEntityMapper agreementEntityMapper;

    @Autowired
    private AgreementLogEntityMapper agreementLogEntityMapper;

    @Autowired

    private ICacheClient redisClient;

    /**
     * 1)注册功能：默认未完善信息；
     * 2)注册成功后发送mq消息，让别的服务初始化数据；
     * 3)记录登录日志;
     *
     * @param baseRequest 参数模型
     * @return
     */
    @Transactional
    @Override
    public LoginResult register(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        //对注册接口做幂等性处理：注册成功，删除缓存，注册失败提示用户
        String exist = redisClient.get(REPEAT_REGISTER_PREFIX + mobile);
        if (StringUtils.isBlank(exist)) {
            String mobileEncrypt = AESUtil.encryptV0(mobile);
            AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobileEncrypt);
            if (accountInfoEntity == null) {
                redisClient.set(REPEAT_REGISTER_PREFIX + mobile, mobile, 30);
                try {
                    Date currentTime = new Date();
                    int productType = baseRequest.getProductType();
                    int sourceType = baseRequest.getSourceType();
                    String password = baseRequest.getPassword();
                    AccountInfoEntity accountInfo = new AccountInfoEntity();
                    accountInfo.setMobilePhone(mobileEncrypt);
                    if (StringUtils.isEmpty(password)) {
                        password = "";
                    }
                    accountInfo.setPassword(password);
                    accountInfo.setCreatedTime(currentTime);
                    accountInfo.setCreatedId(0);
                    accountInfo.setModifiedId(0);
                    accountInfo.setModifiedTime(currentTime);
                    accountInfo.setRegTime(currentTime);
                    accountInfo.setDeleteFlag(1);
                    accountInfo.setSex(0);
                    accountInfo.setRegisterProduct(productType);
                    accountInfo.setRegisterSource(sourceType);
                    accountInfoDetailMapper.insertSelective(accountInfo);
                    Integer acctId = accountInfo.getId();
                    accountInfoDetailMapper.updateCreateInfo(acctId);
                    Account account = new Account();
                    account.setAcctId(acctId);
                    account.setMobilePhone(mobileEncrypt);
                    account.setDeleteFlag(1);
                    account.setCreatId(0L);
                    account.setModifyId(0L);
                    account.setCreatTime(currentTime);
                    account.setModifyTime(currentTime);
                    account.setFirstLoginTime(currentTime);
                    account.setLastLoginTime(currentTime);
                    account.setRegisterSource(sourceType);
                    account.setPassword(password);
                    if (!StringUtils.isBlank(password)) {
                        account.setEntireFlag(3);
                    }
                    accountMapper.insertSelective(account);
                    Long userId = account.getId();
                    Account accountToken = new Account();
                    accountToken.setId(userId);
                    accountToken.setAcctId(acctId);
                    accountToken.setCreatTime(currentTime);
                    accountToken.setMobilePhone(mobile);
                    accountToken.setRegisterSource(sourceType);
                    String newToken = tokenUtils.generateToken(accountToken);
                    LoginResult result = new LoginResult();
                    result.setToken(newToken);
                    result.setUserId(userId);
                    result.setEntireFlag(1);
                    result.setDoctorId(EncryptUtils.encryptContent(userId + "", EncryptConstants.ENCRYPT_TYPE_ID));
                    result.setMobile(mobile);
                  /*  ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    try {
                        dos.writeLong(userId);
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    queueProducer.send(bos.toByteArray());*/
                    LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, baseRequest.getSourceType(),
                            AccountTypeEnum.LOGIN_REGISTER.getCode(), baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(),
                            AccountTypeEnum.LOG_TYPE_LOGIN.getCode(),newToken);
                    picaLogUtils.info(entity);
                    processAgreement(userId);
                    processRoleMap(userId);
                    redisClient.del(REPEAT_REGISTER_PREFIX + mobile);
                    return result;
                } catch (Exception e) {
                    //向上抛出异常，让异常处理框架捕获到
                    throw new AccountException(AccountExceptionEnum.PICA_REGISTER_FAIL);
                } finally {
                    //如果在注册过程中抛出异常，就删除redis中的注册标记
                    redisClient.del(REPEAT_REGISTER_PREFIX + mobile);
                }
            } else {
                throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER);
            }
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER);
        }
    }

    /**
     * 异步处理用户角色
     *
     * @param userId
     */
    private void processRoleMap(Long userId) {
        ExecutorServiceUtils.getExecutor().submit(new Runnable() {
            @Override
            public void run() {
                Date date = new Date();
                PUserRole pUserRole = new PUserRole();
                pUserRole.setSystemId(5);
                pUserRole.setUserRoleId(2);
                pUserRole.setUserId(userId.intValue());
                pUserRole.setUserType(1);
                pUserRole.setStatus(2);
                pUserRole.setDeleteFlag(1);
                pUserRole.setCreatId(userId.intValue());
                pUserRole.setCreatTime(date);
                pUserRole.setModifyId(userId.intValue());
                pUserRole.setModifyTime(date);
                pUserRoleMapper.insertSelective(pUserRole);
                pUserRole.setSystemId(1);
                pUserRoleMapper.insertSelective(pUserRole);
                pUserRole.setSystemId(3);
                pUserRoleMapper.insertSelective(pUserRole);
            }
        });
    }

    /**
     * 长海项目医生自动注册，并完善信息
     *
     * @param request
     */
    @Override
    public void ocinRegister(OCINRequest request) {
        String mobile = request.getMobile();
        String name = request.getName();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobile);
        if (accountInfoEntity == null) {
            Date currentTime = new Date();
            int productType = request.getProductType();
            int sourceType = request.getSourceType();
            AccountInfoEntity accountInfo = new AccountInfoEntity();
            accountInfo.setMobilePhone(mobile);
            accountInfo.setPassword("");
            accountInfo.setCreatedTime(currentTime);
            accountInfo.setCreatedId(0);
            accountInfo.setModifiedId(0);
            accountInfo.setModifiedTime(currentTime);
            accountInfo.setRegTime(currentTime);
            accountInfo.setDeleteFlag(1);
            accountInfo.setSex(0);
            accountInfo.setName(name);
            accountInfo.setRegisterProduct(productType);
            accountInfo.setRegisterSource(sourceType);
            accountInfoDetailMapper.insertSelective(accountInfo);
            Integer acctId = accountInfo.getId();
            accountInfoDetailMapper.updateCreateInfo(acctId);
            //数据插入医生表中
            Account account = new Account();
            account.setAcctId(acctId);
            account.setMobilePhone(mobile);
            account.setDeleteFlag(1);
            account.setCreatId(0L);
            account.setModifyId(0L);
            account.setCreatTime(currentTime);
            account.setModifyTime(currentTime);
            account.setFirstLoginTime(currentTime);
            account.setLastLoginTime(currentTime);
            account.setRegisterSource(sourceType);
            account.setPassword("");
            account.setName(name);
            accountMapper.insertSelective(account);
            Long userId = accountUtils.getUserIdByAcctId(productType, acctId);
            processAgreement(userId);
            /*PrefectInfoReq prefectInfoReq = new PrefectInfoReq();
            prefectInfoReq.setDoctorId(userId);
            prefectInfoReq.setHospitalId(request.getHospitalId().longValue());
            prefectInfoReq.setName(request.getName());
            doctorServiceClient.prefectInfo(prefectInfoReq);
            */
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER.getCode(), AccountExceptionEnum.PICA_ALREADY_REGISTER.getCode());
        }
    }

    /**
     * 异步处理协议信息
     * 1)从协议表中获取最新的协议信息；
     * 2)将协议加入到用户协议表中
     */
    private void processAgreement(Long userId) {
        ExecutorService executor = ExecutorServiceUtils.getExecutor();
        executor.submit(() -> {
//            //用户协议
//            Date currentTime = new Date();
//            Integer userVersion = agreementEntityMapper.selectByType(AccountAgreementEnum.USER_AGREEMENT.getCode());
//            AgreementLogEntity userAgreementLogEntity = new AgreementLogEntity();
//            userAgreementLogEntity.setAgreement_type(AccountAgreementEnum.USER_AGREEMENT.getCode());
//            userAgreementLogEntity.setDoctor_id(userId);
//            userAgreementLogEntity.setVersion(userVersion.toString());
//            userAgreementLogEntity.setCreated_id(userId);
//            userAgreementLogEntity.setCreated_time(currentTime);
//            userAgreementLogEntity.setModified_id(userId);
//            userAgreementLogEntity.setModified_time(currentTime);
//            userAgreementLogEntity.setDelete_flag(1);
//            agreementLogEntityMapper.insert(userAgreementLogEntity);
//            //隐私协议
//            Integer privateVersion = agreementEntityMapper.selectByType(AccountAgreementEnum.PRIVACY_AGREEMENT.getCode());
//            AgreementLogEntity privateAgreementLogEntity = new AgreementLogEntity();
//            privateAgreementLogEntity.setAgreement_type(AccountAgreementEnum.PRIVACY_AGREEMENT.getCode());
//            privateAgreementLogEntity.setDoctor_id(userId);
//            privateAgreementLogEntity.setVersion(privateVersion.toString());
//            privateAgreementLogEntity.setCreated_id(userId);
//            privateAgreementLogEntity.setCreated_time(currentTime);
//            privateAgreementLogEntity.setModified_id(userId);
//            privateAgreementLogEntity.setModified_time(currentTime);
//            privateAgreementLogEntity.setDelete_flag(1);
//            agreementLogEntityMapper.insert(privateAgreementLogEntity);


            Integer protocolId = agreementLogEntityMapper.getLatestProtocolId(2);  //获取最新用户协议ID
            PProtocolLog log = new PProtocolLog();
            log.setUserId(userId.toString());
            log.setProtocolId(protocolId);
            log.setUserType(2);
            log.setType(2);
            log.setStatus((short) 1);
            log.setCreatedId(userId.intValue());
            log.setModifiedId(userId.intValue());
            agreementLogEntityMapper.insertProtocolLog(log);
            agreementLogEntityMapper.updateSignNum(protocolId);  //更新用户协议签署数量

            protocolId = agreementLogEntityMapper.getLatestProtocolId(3);  //获取最新隐私协议ID
            log.setProtocolId(protocolId);
            log.setType(3);
            agreementLogEntityMapper.insertProtocolLog(log);
            agreementLogEntityMapper.updateSignNum(protocolId);  //更新隐私协议签署数量
        });
    }
}
