package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.server.entity.LogLoginAes;
import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.entity.PICAPDoctor;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.resp.UnifiedVerificationResp;
import com.pica.cloud.foundation.entity.PicaResponse;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.vo.OneClickLoginResultVo;

public interface LoginService {
    /**
     * 密码登录功能
     *
     * @param request 参数模型
     * @return
     */
    LoginResult login(BaseRequest request);

    /**
     * 一键登录功能
     *
     * @param request 参数模型
     * @return
     */
    LoginResult loginAndRegister(BaseRequest request);

    /**
     * 微信登录
     *
     * @param baseRequest 参数模型
     */
    LoginResult loginByWeChat(BaseRequest baseRequest);

    /**
     * 微信登陆第二步
     *
     * @param request 参数模型
     * @return
     */
    LoginResult loginByWeChatStep(BaseRequest request);

    /**
     * 解除绑定
     *
     * @param doctorId 账户id
     */
    void unbindWeChat(long doctorId);


    /**
     * 绑定微信接口
     *
     * @param request 参数模型
     */
    String bindWeChat(long doctorId, BaseRequest request);

    PICAPDoctor queryDoctor(long doctorId);

    /**
     * @Description 统一校验(传空则不会校验)
     * @Author Chongwen.jiang
     * @Date 2020/2/20 16:55
     * @ModifyDate 2020/2/20 16:55
     * @Params [request]
     * @Return com.pica.cloud.foundation.entity.PicaResponse
     */
    void preLoginValidate(BaseRequest request);

    LoginResult oneClickLogin(OneClickLoginReq req);

    /**
     * @Description 苹果登录授权
     * @Author Chongwen.jiang
     * @Date 2020/2/24 10:10
     * @ModifyDate 2020/2/24 10:10
     * @Params [baseRequest]
     * @Return com.pica.cloud.account.account.server.entity.LoginResult
     */
    LoginResult loginByApple(BaseRequest baseRequest);

    /**
     * @Description 苹果登录绑定手机号
     * @Author Chongwen.jiang
     * @Date 2020/2/24 10:10
     * @ModifyDate 2020/2/24 10:10
     * @Params [request]
     * @Return com.pica.cloud.account.account.server.entity.LoginResult
     */
    LoginResult loginByAppleStep(BaseRequest request);

    int insertLoginAesLog(LogLoginAes aes);
}
