package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.req.AcctPatFamilyReq;
import com.pica.cloud.account.account.common.req.AcctPatInfoReq;
import com.pica.cloud.account.account.common.req.AcctPatPageReq;
import com.pica.cloud.account.account.common.req.InitAcctReq;
import com.pica.cloud.account.account.common.resp.PatBindResp;
import com.pica.cloud.account.account.common.resp.PatFamilyResp;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


@FeignClient(name = "13201-pica-cloud-account")
public interface PatHealthPackClient {

    @GetMapping(value = "/account/pat-health/acctId/unionId/{unionId}")
    PicaResponse<Integer> getAcctIdByUnionId(@PathVariable("unionId") String unionId);

    @GetMapping(value = "/account/pat-health/acctId/patId/{patientId}")
    PicaResponse<Integer> getAcctIdByPatId(@PathVariable("patientId") Integer patientId);

    @GetMapping(value = "/account/pat-health/directPatIds/{patientId}")
    PicaResponse<List<Integer>> getDirectPatIdsByPatId(@PathVariable("patientId") Integer patientId);

    @GetMapping(value = "/account/pat-health/familyPats/{acctId}/containAcct/{containAcct}")
    PicaResponse<PatFamilyResp> getFamilyPatsByAcctId(@PathVariable("acctId") Integer acctId, @PathVariable("containAcct") Integer containAcct);

    @PostMapping(value = "/account/pat-health/acct")
    PicaResponse<Integer> saveAcct(@RequestBody AcctPatInfoReq patInfoReq);

    @PostMapping(value = "/account/pat-health/acct/bindUnion")
    PicaResponse<PatBindResp> bindUnion(@RequestBody AcctPatInfoReq patInfoReq);

    @PostMapping(value = "/account/pat-health/family/member")
    PicaResponse<PatFamilyResp> saveMember(@RequestBody AcctPatFamilyReq familyReqReq);

    @GetMapping(value = "/account/pat-health/familyAcct/patId/{patId}")
    PicaResponse<Integer> getFamilyAcctPatId(@PathVariable("patId") Integer patId);

    @PostMapping(value = "/account/pat-health/init/accts")
    PicaResponse initAccts(@RequestBody List<InitAcctReq> initAcctReqList);

    @PostMapping(value = "/patIds/query/page")
    PicaResponse<List<Integer>> queryByPage(@RequestBody AcctPatPageReq patPageReq);

}
