package com.pica.cloud.account.account.server.job;

import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created on 2019/12/16 17:53
 * author:crs
 * Description:记录doctor修改记录日志
 */
@JobHandler(value = "DoctorLogHandler")
@Component
public class DoctorLogHandler extends IJobHandler {

    @Autowired
    private DoctorMapper doctorMapper;

    @Override
    public ReturnT<String> execute(String s) throws Exception {
        XxlJobLogger.log("doctorLogRecord start-----");
        Integer rows = doctorMapper.updateDoctorModifyRecord();
        XxlJobLogger.log("doctorLogRecord end-----"+rows);
        return SUCCESS;
    }
}
