package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.service.AccountService;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author andong
 * @create 2019/6/6
 */
@Api(description = "用户状态")
@RestController
@RequestMapping("/status")
public class AccountStatusController extends AccountBaseController {

    @Autowired
    private AccountService accountService;

    @ApiOperation("获取用户状态信息")
    @GetMapping("")
    public PicaResponse<Account> getStatus() {
        long doctorId = super.getDoctorIdByToken();
        Account account = accountService.getById(doctorId);
        return PicaResponse.toResponse(account);
    }
}
