package com.pica.cloud.account.account.server.util;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.account.account.server.entity.WeChatEntity;
import com.pica.cloud.account.account.server.entity.WeChatUserInfoEntity;
import com.pica.cloud.foundation.utils.constants.WeChatConstants;
import com.pica.cloud.foundation.utils.utils.JsonUtil;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeChatUtils {

    private static Logger logger = LoggerFactory.getLogger(WeChatUtils.class);

    public static WeChatEntity getAuthorizationInfo(String appId, String appSecret, String code) {
        logger.info("网页授权获取access_token: code:{}", code);
        String requestUrl = WeChatConstants.AUTH_ACCESS_TOKEN_URL.replace("APPID", appId).replace("SECRET", appSecret).replace("CODE", code);
        JSONObject jsonObject = WeChatToolUtil.httpRequest(requestUrl, "GET", null);
        WeChatEntity accessToken = null;
        // 如果请求成功
        if (null != jsonObject) {
            try {
                accessToken = JsonUtil.toGsonBean(jsonObject.toString(), WeChatEntity.class);
                logger.info("网页授权获取access_token: access_token:{} openid:{}", accessToken.getAccess_token(), accessToken.getOpenid());
            } catch (JSONException e) {
                // 获取token失败
                logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
            }
        } else {
            // 获取token失败
            logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));

        }
        return accessToken;
    }

    public static Map getWeChatUserInfo(Map map, String url) {
        String param = "access_token=" + map.get("access_token") + "&openid=" + map.get("openid") + "&lang=zh_CN";
        List<NameValuePair> nameValuePairs = URLEncodedUtils.parse(param, Charset.forName("utf-8"));
        HttpGet method = null;
        try {
            url = url + param;
            URL url1 = new URL(url);
            URI uri = new URI(url1.getProtocol(), url1.getHost(), url1.getPath(), url1.getQuery(), null);
            method = new HttpGet(uri);
            // 建立一个NameValuePair数组，用于存储欲传送的参数
            method.addHeader("Content-type", "application/json; charset=utf-8");
            method.setHeader("Accept", "application/json");

            HttpResponse response = HttpClients.createDefault().execute(method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.SC_OK) {
                String body = EntityUtils.toString(response.getEntity(), "utf-8");
                return JSON.parseObject(body, Map.class);

            } else {
                logger.warn("微信获取用户信息（包括UnionID）失败，param:{}, result:{}", JSON.toJSONString(map), JSON.toJSONString(response));
                return new HashMap();
            }

        } catch (IOException e) {
            logger.error("微信获取access_token异常，param:{}", JSON.toJSONString(map), e);
            return new HashMap();
        } catch (URISyntaxException e) {
            logger.error("异常抛出exception ", e);
        } finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return new HashMap();
    }


    public static WeChatUserInfoEntity mergeWechatUserInfo(Map map, String openid){
        WeChatUserInfoEntity user = new WeChatUserInfoEntity();
        user.setOpenid(openid);
        user.setLanguage("zh_CN");
        if (StringUtil.isNotNull(map) && map.size() > 0) {
            user.setSubscribe((Integer) map.get("subscribe"));
            user.setNickname((String) (map.get("nickname")));
            user.setSex((Integer) map.get("sex"));
            user.setLanguage((String) map.get("language"));
            user.setCity((String) map.get("city"));
            user.setProvince((String) map.get("province"));
            user.setCountry((String) map.get("country"));
            user.setHeadimgurl((String) map.get("headimgurl"));
            user.setSubscribe_time(new Date(map.get("subscribe_time") == null ? 1501052712L : Long.valueOf(map.get("subscribe_time").toString())));
            user.setRemark((String) map.get("remark"));
            user.setUnionid((String) map.get("unionid"));
            user.setGroupid((Integer) map.get("groupid"));
            user.setTagid_list(JSON.toJSONString(map.get("tagid_list")));
        }
        return user;
    }

}
