package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.req.DoctorReq;
import com.pica.cloud.account.account.server.req.RevertAcctsReq;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created on 2019/9/10 18:51
 * author:crs
 * Description:云鹊医 获取用户信息资源
 */
@Api(description = "云鹊医用户信息信息资源")
@RestController
@RequestMapping("/doctor")
public class DoctorController extends AccountBaseController {

    @Autowired
    private DoctorService doctorService;

    @ApiOperation("获取医生信息用接口")
    @GetMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse<Doctor> getDoctorInfo() {
        AccountUser accountUser = null;
        try {
            accountUser = super.getAccountUser();
        } catch (Exception e) {
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
        Integer userId = accountUser.getId();
        Doctor doctorInfo = doctorService.getDoctorInfo(userId);
        String mobilePhone = doctorInfo.getMobilePhone();
        String dencrypt = EncryptUtils.decryptContent(mobilePhone, EncryptConstants.ENCRYPT_TYPE_MOBILE, super.getToken());
        mobilePhone = dencrypt.substring(0, 3) + "****" + dencrypt.substring(7, 11);
        doctorInfo.setMobilePhone(mobilePhone);
        if (StringUtils.isNotBlank(doctorInfo.getCard())) {
            doctorInfo.setCard(EncryptUtils.decryptContent(doctorInfo.getCard(), EncryptConstants.ENCRYPT_TYPE_DOCTOR_IDNO, EncryptConstants.ENCRYPT_DECRYPT_KEY));
        }
        return PicaResponse.toResponse(doctorInfo);
    }

    @ApiOperation("修改医生信息接口")
    @PutMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse modifyDoctorInfo(@RequestBody Doctor doctor) {
        doctorService.modifyDoctorInfo(doctor,super.getDoctorIdByToken());
        return PicaResponse.toResponse();
    }

    @ApiOperation("注册完新用户 完善信息接口")
    @PutMapping(value = "/register/welcome", produces = "application/json;charset=utf-8")
    @EnabledLoginValidate
    public PicaResponse registerWelcome(@RequestBody DoctorReq doctorReq) {
        doctorReq.setId(fetchPicaUser().getId());
        doctorService.registerWelcome(doctorReq);
        return PicaResponse.toResponse();
    }

    /**
     * 当前医生是哪个admin账户添加的
     *
     * @param doctor
     * @return
     */
    @ApiOperation("客服系统新增医生")
    @PostMapping(value = "/info", produces = "application/json;charset=utf-8")
    public PicaResponse addDoctorInfo(@RequestBody Doctor doctor) {
        if (doctor != null && doctor.getMobilePhone() != null) {
            AccountUtils.checkMobilePhone(doctor.getMobilePhone());
            AccountUtils.checkPassword(doctor.getPassword());
            Integer userId = doctorService.addDoctorInfo(doctor,super.getDoctorIdByToken());
            return PicaResponse.toResponse(userId);
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_PARAMS_ERROR);
        }
    }


    @ApiOperation("客服系统删除医生信息")
    @DeleteMapping(value = "/delete/{id}")
    public PicaResponse deleteDoctor(@PathVariable("id") Integer id) {
        doctorService.deleteDoctorInfo(id,super.getDoctorIdByToken());
        return PicaResponse.toResponse();
    }

    /**
     * @Description 恢复客服系统误删除医生
     * @Author peijun.zhao
     * @Date 2020/6/3 17:39
     * @ModifyDate 2020/6/3 17:39
     * @Params [doctorIds]
     * @Return com.pica.cloud.foundation.entity.PicaResponse
     */
    @PostMapping(value = "/revert")
    @EnabledLoginValidate
    public PicaResponse revertDoctor(@RequestBody RevertAcctsReq revertAcctsReq) {
        if("revertAccts".equals(revertAcctsReq.getType())){
            doctorService.revertAccts(revertAcctsReq.getDoctorIds());
        }
        return PicaResponse.toResponse();
    }
}
