package com.pica.cloud.account.account.server.enums;

/**
 * @Description 统一校验响应枚举类
 * @Author Chongwen.jiang
 * @Date 2020/2/20 18:19
 * @ModifyDate 2020/2/20 18:19
 * @Params
 * @Return
 */
public enum BizTypeRespEnum {

    // 风控禁止发送
    RC_SEND_FAIL(2, "发送失败"),
    RC_TRIGGER(3, "需要触发风控滑动验证"),
    //  账号、IP、设备在黑名单内，前端提示发送成功,后端不发送短信
    RC_BLACKLIST(4, "发送成功"),
    RC_DAY_LIMIT(5, "今日获取验证码次数以超过上限，请使用账户密码登录"),
    RC_60_SECOND_LIMIT(6, "验证码发送频率过高，请{remainTime}秒后再试"),

    MOBILE_REG_FALSE(7, "请输入正确的手机号"),
    MOBILE_REG_TRUE(8, "手机号符合规则"),
    MOBILE_NOT_REGIST(9, "该手机号{mobile}尚未设置密码，请先设置密码。"),
    MOBILE_NOT_SETED_PASSWORD(10, "该手机号{mobile}尚未设置密码，请先设置密码。"),
    MOBILE_SETED_PASSWORD(11, "手机号已设置密码"),


    XXX(0, "xxxxxx");

    private Integer code;
    private String msg;

    BizTypeRespEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setType(String msg) {
        this.msg = msg;
    }
}
