package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountUserInfoEntity;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class UserInfoServerImpl implements UserInfoService {

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Override
    public void updateUserInfo(AccountUserInfoEntity accountUserInfoEntity) {
        accountUserInfoEntity.setModifyTime(new Date());
        accountUserInfoEntity.setModifyId(accountUserInfoEntity.getAcctId());
        accountUserInfoMapper.updateByPrimaryKeySelective(accountUserInfoEntity);
    }

    @Override
    public AccountUserInfoEntity getUserInfo(Integer acctId) {
        return accountUserInfoMapper.selectByAcctId(acctId);
    }
}
