package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountUserInfoEntity;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.service.UserInfoService;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "用户信息资源")
@RestController
public class UserInfoController extends AccountBaseController {

    @Autowired
    private UserInfoService userInfoService;

    /**
     * 获取用户信息接口
     *
     * @return
     */
    @ApiOperation("获取用户信息接口")
    @GetMapping(value = "/user/info")
    public PicaResponse getUserInfo() {
        Integer acctId = super.getAcctId();
        AccountUserInfoEntity userInfo = userInfoService.getUserInfo(acctId);
        return PicaResponse.toResponse(userInfo);
    }

    /**
     * 修改用户信息接口
     *
     * @return
     */
    @ApiOperation("修改用户信息")
    @PutMapping(value = "/user/info")
    public PicaResponse putUserInfo(@RequestBody EncryptEntity entity) throws Exception {
        Integer acctId = super.getAcctId();
        AccountUserInfoEntity request = CryptoUtil.decrypt(entity, AccountUserInfoEntity.class);
        request.setAcctId(acctId);
        userInfoService.updateUserInfo(request);
        return PicaResponse.toResponse();
    }

}
