package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountWeChatInfoEntity;
import com.pica.cloud.account.account.server.mapper.AccountWeChatInfoMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.WechatService;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class WechatServiceImpl implements WechatService {

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountWeChatInfoMapper weChatInfoMapper;

    @Override
    public AccountWeChatInfoEntity getAccountWechatInfo(PicaUser user) {
        String unionId = doctorMapper.getUnionIdByDoctorId(user.getId());
        if(StringUtil.isEmpty(unionId)){
            return null;
        }else {
            return weChatInfoMapper.selectByUnionId(unionId);
        }
    }
}
