package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaUser;
import com.pica.cloud.foundation.redis.ICacheClient;

import com.pica.cloud.foundation.service.starter.common.BaseController;
import com.pica.cloud.foundation.service.starter.interceptor.LoginPermission;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

import java.util.*;

@RestController
public class RedisTestController extends BaseController {
    @Autowired
    private ICacheClient redisClient;

    @RequestMapping(value = "/redis", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    @LoginPermission
    public PicaResponse<Map<String, String>> redis() {
        // http://localhost:11501/hospital/hospitals/redis
        // cluster
        String token = getTokenFromHeader();
        Map<String, String> map = new HashMap<>();
        map.put("id", "1111111");
        map.put("token", token);
        map.put("sysCode", getSysCodeFromHeader());

        try {
            token = redisClient.saveToken(map, 3600);
        } catch (Exception ex) {
            // nothing to do
        }
        System.out.println(token);
        Map<String, String> map1 = redisClient.getToken(token);
        System.out.println(JSON.toJSON(map1));
        PicaUser user = fetchPicaUser();
        System.out.println(JSON.toJSON(user));

        // sentinel
        Set<String> set1 = new HashSet<>();
        set1.add("192.168.140.27:17000");
        set1.add("192.168.140.28:17000");
        set1.add("192.168.140.29:17000");
        JedisSentinelPool pool1 = new JedisSentinelPool("master01", set1, "Uu49Kz1olY85HQBu");
        Jedis jedis1 = pool1.getResource();
        System.out.println("sentinel dev - " + jedis1.get("token-" + token));

        Set<String> set2 = new HashSet<>();
        set2.add("192.168.110.68:17000");
        set2.add("192.168.110.69:17001");
        set2.add("192.168.110.70:17002");
        JedisSentinelPool pool2 = new JedisSentinelPool("master01", set2, "Uu49Kz1olY85HQBu");
        Jedis jedis2 = pool2.getResource();
        System.out.println("sentinel test - " + jedis2.get("token-" + token));

        Set<String> set3 = new HashSet<>();
        set3.add("192.168.110.177:17000");
        set3.add("192.168.110.178:17000");
        set3.add("192.168.110.179:17000");
        JedisSentinelPool pool3 = new JedisSentinelPool("master01", set3, "Uu49Kz1olY85HQBu");
        Jedis jedis3 = pool3.getResource();
        System.out.println("sentinel uat - " + jedis3.get("token-" + token));

        redisClient.deleteToken(token);

        try {
            PicaUser user1 = fetchPicaUser();
        } catch (Exception ex) {
            System.out.println("Exception -> the user has been deleted");
        }

        Map<String, String> map2 = new HashMap<>();
        map2.put("id", "1111111");
        map2.put("token", token);
        map2.put("sysCode", getSysCodeFromHeader());
        try {
            token = redisClient.saveToken(map2, 3600);
        } catch (Exception ex) {
            // nothing to do
        }

        String clusterKey = "cluster-key-001";
        String clusterValue = "cluster-value-001";

        redisClient.set(clusterKey, clusterValue);
        System.out.println("cluster -> " + redisClient.get(clusterKey));
        System.out.println("dev get cluster value -> " + pool1.getResource().get(clusterKey));
        System.out.println("test1 get cluster value -> " + pool2.getResource().get(clusterKey));
        System.out.println("uat get cluster value -> " + pool3.getResource().get(clusterKey));

        String sentKey = "sent-key-001";
        String sentValue = "sent-value-001";
        pool1.getResource().set(sentKey, sentValue);
        System.out.println("dev sentinel -> " + pool1.getResource().get(sentKey));

        pool2.getResource().set(sentKey, sentValue);
        System.out.println("test1 sentinel -> " + pool2.getResource().get(sentKey));

        pool3.getResource().set(sentKey, sentValue);
        System.out.println("uat sentinel -> " + pool3.getResource().get(sentKey));

        return PicaResponse.toResponse(token);
    }
}
