package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.common.req.AccountInfoReq;
import com.pica.cloud.account.account.server.service.AccountInfoService;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.Collections;
import java.util.List;

/**
 * @author andong
 * @create 2019/7/18
 */
@Api(description = "账号信息")
@RestController
@RequestMapping("/info")
public class AccountInfoController {

    @Autowired
    private AccountInfoService accountInfoService;

    @ApiOperation("获取用户数量")
    @GetMapping("/count")
    public PicaResponse<Integer> getCount(AccountInfoReq req) {
        if (req.getProvinceId() == null && req.getCityId() == null && req.getCountyId() == null
                && CollectionUtils.isEmpty(req.getTitleIds()) && CollectionUtils.isEmpty(req.getLevelGrades())) {
            return PicaResponse.toResponse(accountInfoService.getTotalCount());
        }
        return PicaResponse.toResponse(accountInfoService.getCount(req));
    }

    @ApiOperation("获取医生ID列表")
    @GetMapping("/doctorIds")
    public PicaResponse<List<Integer>> getDoctorIds(AccountInfoReq req) {
        if (req.getProvinceId() == null && req.getCityId() == null && req.getCountyId() == null
                && CollectionUtils.isEmpty(req.getTitleIds()) && CollectionUtils.isEmpty(req.getLevelGrades())) {
            return PicaResponse.toResponse(Collections.emptyList());
        }
        return PicaResponse.toResponse(accountInfoService.getDoctorIds(req));
    }

}
