package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.common.dto.AccountWeChatInfoDto;
import com.pica.cloud.account.account.common.resp.DoctorUnionResp;
import com.pica.cloud.account.account.server.entity.AccountUnionEntity;
import com.pica.cloud.account.account.server.entity.AccountWeChatInfoEntity;
import com.pica.cloud.account.account.server.mapper.AccountWeChatInfoMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.model.WechatInfoDto;
import com.pica.cloud.account.account.server.service.AccountUnionService;
import com.pica.cloud.account.account.server.service.WechatService;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;


@Service
public class WechatServiceImpl implements WechatService {

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountWeChatInfoMapper weChatInfoMapper;

    @Autowired
    private AccountUnionService accountUnionService;

    @Override
    public AccountWeChatInfoEntity getAccountWechatInfo(PicaUser user) {
        String unionId = doctorMapper.getUnionIdByDoctorId(user.getId());
        if(StringUtil.isEmpty(unionId)){
            return new AccountWeChatInfoEntity();
        }else {
            AccountWeChatInfoEntity entity = weChatInfoMapper.selectByUnionId(unionId);
            if(entity == null) {
                entity = new AccountWeChatInfoEntity();
            }
            return entity;
        }
    }

    @Override
    public AccountWeChatInfoDto getAccountWechatInfoDto(PicaUser user) {
        AccountWeChatInfoEntity entity = getAccountWechatInfo(user);
        AccountWeChatInfoDto dto = new AccountWeChatInfoDto();
        try {
            BeanUtils.copyProperties(dto, entity);
        } catch (Exception ex) {
            // ignore
        }
        return dto;
    }

    @Override
    public Map<Integer, String> getAccountWechatInfoBatch(List<Integer> docIds) {
        if(CollectionUtils.isEmpty(docIds)){
            return null;
        }
        Map<Integer, String> doctorOpenMap = new HashMap<>();

        List<WechatInfoDto> wechatInfoDtos = doctorMapper.getBatchUnionIdByDoctorId(docIds);
        Map<String, Integer> unionMap = new HashMap<>();
        for(WechatInfoDto dto : wechatInfoDtos){
            unionMap.put(dto.getUnionId(),dto.getDoctorId());
        }
        List<String> unionIds = wechatInfoDtos.stream().map(obj -> obj.getUnionId()).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(unionIds)){
            List<AccountWeChatInfoEntity> wechatList = weChatInfoMapper.selectBatchByUnionId(unionIds);
            for(AccountWeChatInfoEntity entity : wechatList){
                if(unionMap.containsKey(entity.getUnionid())){
                    doctorOpenMap.put(unionMap.get(entity.getUnionid()),entity.getOpenid());
                }
            }
        }

        for(Integer docId : docIds){
            if(!doctorOpenMap.containsKey(docId)){
                doctorOpenMap.put(docId,null);
            }
        }

        return doctorOpenMap;
    }

    @Override
    public DoctorUnionResp getDoctorByUnionid(String unionid){
        AccountUnionEntity accountUnionEntity = accountUnionService.selectInfoByUnionId(unionid);
        DoctorUnionResp doctorUnionfoModel = new DoctorUnionResp();
        if (StringUtil.isNotNull(accountUnionEntity)) {
            doctorUnionfoModel = doctorMapper.getDoctorByAcctId(accountUnionEntity.getAcctId());
        }
        return doctorUnionfoModel;
    }

    @Override
    public Integer getDoctorByOpenid(String openId) {
        AccountWeChatInfoEntity entity = weChatInfoMapper.selectByOpenId(openId);
        String unionId = "";
        if (StringUtil.isNotNull(entity)) {
            unionId = entity.getUnionid();

        } else {
            unionId = doctorMapper.selectIdByOpenId(openId);
        }
        DoctorUnionResp doctorUnionfoModel = getDoctorByUnionid(unionId);
        if (StringUtil.isNotNull(doctorUnionfoModel)) {
            return doctorUnionfoModel.getDoctorId();
        }
        return null;
    }
}
