// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.req.HospitalSaasUserListReq;
import com.pica.cloud.account.account.server.req.HospitalSaasUserReq;
import com.pica.cloud.account.account.server.resp.HospitalRoleResp;
import com.pica.cloud.account.account.server.resp.HospitalSaasUserDetailResp;
import com.pica.cloud.account.account.server.resp.HospitalSaasUserResp;
import com.pica.cloud.account.account.server.service.HospitalSaasRoleService;
import com.pica.cloud.account.account.server.service.HospitalSaasUserService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author qinwh
 * @Date 2022/3/1 14:45
 */
@Api(description = "机构saas人员资源")
@RestController
@RequestMapping("/saas")
public class HospitalSaasUserController extends AccountBaseController {
    @Autowired
    private HospitalSaasUserService hospitalSaasUserService;
    @Autowired
    private HospitalSaasRoleService hospitalSaasRoleService;

    @ApiOperation("机构saas平台人员注册 0失败 1成功")
    @PostMapping(value = "/hospital/register")
    @EnabledLoginValidate
    public PicaResponse<Integer> register(@RequestBody HospitalSaasUserReq req) {
        return PicaResponse.toResponse(hospitalSaasUserService.register(req, super.getProductType(), super.getSourceType(), getPicaUser()));
    }

    @ApiOperation("机构saas平台人员更新 0失败 1成功")
    @PostMapping(value = "/hospital/upsert")
    @EnabledLoginValidate
    public PicaResponse<Integer> upsert(@RequestBody HospitalSaasUserReq req) {
        return PicaResponse.toResponse(hospitalSaasUserService.upsert(req, getPicaUser()));
    }

    @ApiOperation("机构saas平台人员列表查询")
    @PostMapping(value = "/hospital/list")
    @EnabledLoginValidate
    public PicaResponse<HospitalSaasUserResp> list(@RequestBody HospitalSaasUserListReq req) {
        return PicaResponse.toResponse(hospitalSaasUserService.listByPage(req));
    }

    @ApiOperation("机构saas平台人员删除 0失败 1成功")
    @DeleteMapping(value = "/hospital/delete")
    @EnabledLoginValidate
    public PicaResponse<Integer> delete(@RequestParam("id") Long id) {
        return PicaResponse.toResponse(hospitalSaasUserService.delete(id));
    }

    @ApiOperation("机构saas平台人员账户")
    @GetMapping(value = "/hospital/userDetail")
    @EnabledLoginValidate
    public PicaResponse<HospitalSaasUserDetailResp> userDetail(@RequestHeader("token") String token) {
        return PicaResponse.toResponse(new HospitalSaasUserDetailResp());
    }

    @ApiOperation("机构saas平台人员-角色列表")
    @GetMapping(value = "/hospital/role/listByPage")
    @EnabledLoginValidate
    public PicaResponse<HospitalRoleResp> listByPage() {
        return PicaResponse.toResponse(hospitalSaasRoleService.querySaasRoles());
    }

}
