// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.req;

import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Max;
import javax.validation.constraints.Pattern;


/**
 * @Author qinwh
 * @Date 2022/3/1 10:45
 */
@ApiModel
@Data
public class HospitalSaasUserReq {

    @ApiModelProperty("人员id")
    private Long id;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("机构id")
    private Integer hospitalId;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("备注")
    private String comment;

    @ApiModelProperty("角色id")
    private Long roleId;

    @ApiModelProperty("产品类型")
    private Integer productType;

    @ApiModelProperty("资源类型")
    private Integer sourceType;

    public void checkInsertParams() {
        if (StringUtils.isBlank(this.mobile)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "手机号不能为空");
        }
        if (StringUtils.isBlank(this.name)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "姓名不能为空");
        }
        if (StringUtils.isBlank(this.password)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "密码不能为空");
        }
//        if (null == this.roleId) {
//            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "角色id不能为空");
//        }
        if (this.name.length() > 16) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "姓名长度必须≤16字符！");
        }
        if (!ValidateUtils.isMobile(this.mobile)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "手机号格式不正确！");
        }
        if (null == this.productType) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "产品类型不能为空！");
        }
        if (null == this.sourceType) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "资源类型不能为空！");
        }
    }
}
