package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.configuration.PropertiesConfiguration;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.util.MobileSmsEntityContent;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.CommonUtil;
import com.pica.cloud.foundation.utils.utils.HttpClientUtil;
import com.pica.cloud.foundation.utils.utils.json.Object2Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * controller基类
 * @author andong
 * @create 2019/5/21
 */
public abstract class AccountBaseController extends BaseController {

    private static final String KEY_PREFIX = "token-doctor-";
    private Logger logger = LoggerFactory.getLogger(AccountBaseController.class);
    @Autowired
    private PropertiesConfiguration configuration;

    //从token获取医生ID
    public long getDoctorIdByToken() {
        try {
            PicaUser picaUser = super.fetchPicaUser();
            return picaUser.getId().longValue();
        } catch (Exception ex) {
            throw new PicaException(PicaResultCode.LOGIN_FAILE);
        }
    }

    //获取deviceInfo信息
    public String getDeviceInfo(String key) {
        String deviceInfo = super.getDeviceInfo();
        if (StringUtils.isBlank(key) || StringUtils.isBlank(deviceInfo)) {
            return StringUtils.EMPTY;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject(deviceInfo);
            return jsonObject.getString(key);
        } catch (Exception ex) {
            return StringUtils.EMPTY;
        }
    }

    //保存token，并返回token值(web或app，不包含h5)
    public String saveToken(String token, PicaUser picaUser) {
        if (StringUtils.isNotEmpty(token)) {
            picaUser.setToken(token);
        }

        String sysCode = super.getSysCode();
        if ("9".equals(sysCode)) {
            sysCode = "saas";
        } else if ("10".equals(sysCode)) {
            sysCode = "app";
        }

        String tokenValue = super.getRedisClient().get(KEY_PREFIX + picaUser.getId().toString() + "-" + sysCode);
        if (StringUtils.isNotBlank(tokenValue)) {
            return tokenValue.replace("token-", "");  //token已经存在则直接返回
        }

        try {
            Map<String, String> data = Object2Map.objectToMapString("yyyy-MM-dd HH:mm:ss", picaUser, new String[0]);
            data.put("sysCode", sysCode);
            return super.getRedisClient().saveToken(data, 365*24*3600);  //token有效期365天
        } catch (Exception ex) {
            logger.error("保存token失败，doctorId: {}", picaUser.getId());
            return StringUtils.EMPTY;
        }
    }

    //发送手机短信
    public void sendMobileMessage(String mobile, String content, long senderId) {
        String sysCodeStr = super.getSysCode();
        int sysCode = 10; //默认移动端
        if (StringUtils.isNotBlank(sysCodeStr)) {
            try {
                sysCode = Integer.parseInt(sysCodeStr);
            } catch (Exception ex) {
                logger.error(ex.getMessage(), ex);
            }
        }

        String batchNo = CommonUtil.getBatchNo(sysCode);  //短信批次号
        Map<String,Object> batchMap = new HashMap();  //批量map
        String sign = StringUtils.EMPTY;  //获取消息发送的签名
        MobileSmsEntityContent smsEntity = new MobileSmsEntityContent();
        smsEntity.setMobile(mobile);
        smsEntity.setSms_entity_id(0);
        smsEntity.setContent(content);
        List<MobileSmsEntityContent> list = Arrays.asList(smsEntity);

        batchMap.put("mobileSmsEntityContentList", list);
        batchMap.put("sign", sign);
        batchMap.put("userId", senderId);
        batchMap.put("batchNo", batchNo);

        String postData = JSON.toJSONString(batchMap);
        String messageUrl = configuration.getMessageUrl() + Constants.BATCH_SEND_MESSAGE;
        String jsonObj = HttpClientUtil.httpExecute(messageUrl, postData);
        if (StringUtils.isNotBlank(jsonObj)) {
            logger.info("发送短信成功，返回结果：{}", jsonObj);
        } else {
            logger.error("发送短信失败");
        }
    }
}
