package com.pica.cloud.account.account.server.util;


import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.req.BaseRequest;


/**
 * 加解密工具类
 */
public class CryptoUtil {

    /**
     * 加密数据
     *
     * @param data
     * @return
     * @throws Exception
     */
    public static EncryptEntity encrypt(String data) throws Exception {
        //1、产生AES密钥
        String keyString = AESUtil.generateKeyString();
        //2、用AES法加密数据
        String content = AESUtil.encrypt(keyString, data);
        //3、用RSA加密AES密钥
        String finalKey = RSAUtil.encrypt(keyString);
        EncryptEntity encryptEntity = new EncryptEntity();
        encryptEntity.setContent(content);
        encryptEntity.setKey(finalKey);
        return encryptEntity;
    }

    /**
     * 解密数据
     *
     * @param key
     * @param data
     * @return
     */
    public static String decrypt(String key, String data) throws Exception {
        //获取解密密钥
        String decryptKey = RSAUtil.decrypt(key);
        //解密数据
        String content = AESUtil.decrypt(decryptKey, data);
        return content;
    }


    /**
     * 解密数据
     *
     * @param encryptEntity
     * @return
     * @throws Exception
     */
    public static BaseRequest decrypt(EncryptEntity encryptEntity) throws Exception {
        //获取解密密钥
        String decryptKey = RSAUtil.decrypt(encryptEntity.getKey());
        //解密数据
        String content = AESUtil.decrypt(decryptKey, encryptEntity.getContent());
        //反序列化成对象
        BaseRequest request = (BaseRequest) JSONObject.toJSON(content);
        return request;
    }

}
