package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.AccountUserInfoEntity;
import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.enums.AccountEnumType;
import com.pica.cloud.account.account.server.enums.AccountExceptionType;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class RegisterServiceImpl implements RegisterService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient cacheClient;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Override
    public String register(BaseRequest baseRequest) {
        String mobile = EncryptCreateUtil.encrypt(baseRequest.getMobile());
        //校验用户是否已经注册
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobile);
        if (accountInfoEntity == null) {
            Date currentTime = new Date();
            int productType = baseRequest.getProductType();
            int sourceType = baseRequest.getSourceType();
            AccountInfoEntity accountInfo = new AccountInfoEntity();
            accountInfo.setMobilePhone(EncryptCreateUtil.encrypt(baseRequest.getMobile()));
            if (StringUtils.isNotEmpty(baseRequest.getPassword())) {
                accountInfo.setPassword(EncryptCreateUtil.encrypt(baseRequest.getPassword()));
            } else {
                accountInfo.setPassword("");
            }
            accountInfo.setCreatedTime(currentTime);
            accountInfo.setCreatedId(0);
            accountInfo.setModifiedId(0);
            accountInfo.setModifiedTime(currentTime);
            accountInfo.setRegTime(currentTime);
            accountInfo.setDeleteFlag(1);
            accountInfo.setSex(0);
            accountInfo.setRegisterProduct(productType);
            accountInfo.setRegisterSource(sourceType);
            accountInfoDetailMapper.insertSelective(accountInfo);
            Integer acctId = accountInfo.getId();
            accountInfoDetailMapper.updateCreateInfo(acctId);
            AccountUserInfoEntity accountUserInfoEntity = new AccountUserInfoEntity();
            accountUserInfoEntity.setAcctId(acctId);
            accountUserInfoEntity.setDeleteFlag(1);
            accountUserInfoEntity.setCreateId(acctId);
            accountUserInfoEntity.setModifyId(acctId);
            accountUserInfoEntity.setCreateTime(currentTime);
            accountUserInfoEntity.setModifyTime(currentTime);
            accountUserInfoMapper.insertSelective(accountUserInfoEntity);
            Integer userId = accountUserInfoEntity.getId();
            Account account = new Account();
            account.setId(userId.longValue());
            account.setAcctId(acctId);
            account.setCreatTime(currentTime);
            account.setMobilePhone(mobile);
            account.setRegisterSource(sourceType);
            String newToken = this.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(Constants.TOKEN, newToken);
            jsonObject.put(Constants.USER_ID, userId);
            //记录登录日志
            LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, baseRequest.getSourceType(),
                    AccountEnumType.LOGIN_REGISTER.getCode(), baseRequest.getLoginIp(), AccountEnumType.LOGIN_STATUS_SUCCESS.getCode(),
                    AccountEnumType.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            return jsonObject.toJSONString();
        } else {
            throw new AccountException(AccountExceptionType.PICA_ALREADY_REGISTER);
        }
    }

    /**
     * 生成新的token
     *
     * @param account
     * @return
     */
    private String generateToken(Account account) {
        String sourceType = AccountUtils.getSourceType(account.getRegisterSource());
        String newToken = org.apache.commons.lang3.StringUtils.EMPTY;
        try {
            String value = "token-doctor-" + account.getId().toString();
            //生成新token
            int expiredSeconds = 30 * 24 * 60 * 60;//token有效期30天
            newToken = UUID.randomUUID().toString().replace("-", "").toUpperCase();
            String Key = "token-" + newToken;
            //存储token：(token-FF9FCB0D93A642328A01C279701B7607：token-doctor-1)
            cacheClient.set(Key, value, expiredSeconds);
            //存储token：(token-doctor-12345678-app：token-FF9FCB0D93A642328A01C279701B7607)
            cacheClient.set(value + sourceType, Key, expiredSeconds);
            //用户数据放入缓存
            String userData = cacheClient.hget(value, "id");
            if (org.apache.commons.lang3.StringUtils.isEmpty(userData)) {
                Map<String, String> data = new HashMap<>();
                data.put("token", newToken);
                data.put("id", account.getId() + "");
                data.put("acctId", account.getAcctId() + "");
                data.put("mobile", account.getMobilePhone());
                data.put("name", account.getMobilePhone().replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2"));
                data.put("created_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(account.getCreatTime()));
                data.put("sysCode", sourceType);
                Iterator<Map.Entry<String, String>> iterator = data.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> map = iterator.next();
                    String key = map.getKey();
                    String valueInfo = map.getValue();
                    //存储token：(token-doctor-1：用户数据)
                    cacheClient.hset(value, key, valueInfo);
                }
            }
        } catch (Exception ex) {
            logger.error("生成token异常：{}" + ex.getMessage(), ex);
        }
        return newToken;
    }
}
