// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.req.CardRecognizeEncryptReq;
import com.pica.cloud.account.account.server.service.OcrService;
import com.pica.cloud.account.account.server.util.IPUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @ClassName OcrController
 * @Description
 * @Author Chongwen.jiang
 * @Date 2020/4/24 11:57
 * @ModifyDate 2020/4/24 11:57
 * @Version 1.0
 */
@Api(description = "ocr识别")
@RequestMapping("/ocr")
@RestController
public class OcrController extends AccountBaseController {

    @Autowired
    private OcrService ocrService;


    @ApiOperation("身份证识别(app)")
    @EnabledLoginValidate
    @PostMapping("/cardRecognize")
    public PicaResponse ocrRecognizeApp(HttpServletRequest request,
                                        @RequestBody CardRecognizeEncryptReq req,
                                        @RequestHeader("token") String token,
                                        @RequestHeader("sourceType") Integer sourceType) {
        PicaUser user = super.fetchPicaUser();
        String ip = IPUtil.getIpAdrress(request);
        String deviceIp = super.getDeviceInfo("device_ip");
        return PicaResponse.toResponse(ocrService.ocrRecognizeApp(user, req, token, ip, sourceType, deviceIp));
    }

}
