package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.configuration.PropertiesConfiguration;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.AccountUnionEntity;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeReq;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LogLoginAes;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.*;
import com.pica.cloud.account.account.server.util.*;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.CommonUtil;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "短信验证码资源")
@RestController
public class AutoCodeController extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(AccountController.class);

    @Autowired
    private AccountUnionService accountUnionService;

    @Autowired
    private CaptchaService captchaService;

    @Autowired
    private AccountService accountService;

    @Autowired
    private ICacheClient cacheClient;

    @Autowired
    private AuthCodeService authCodeService;

    @Autowired
    private LoginService loginService;

    @Autowired
    private PropertiesConfiguration propertiesConfiguration;

    @Autowired
    private IntactUtil intactUtil;


    /*@GetMapping("/ip")
    public PicaResponse getIp(HttpServletRequest request) {
        return PicaResponse.toResponse(IPUtil.getIpAdrress(request));
    }*/

    /*@ApiOperation("数据加密-方便测试")
    @PostMapping("/encryptedParams")
    public String getEncryptedParams(@RequestBody BaseRequest request) throws Exception {
        if ("dev".equals(propertiesConfiguration.getEnvironment()) ||
                "test1".equals(propertiesConfiguration.getEnvironment())) {
            String publicKey = "1234567890123456";
            String content = AESUtil.aesEncrypt(JSON.toJSONString(request), publicKey);
            String encryptKey = RSAUtil.encrypt(publicKey);
            Map<String, Object> map = new HashMap<>(2);
            map.put("key", encryptKey);
            map.put("content", content);
            return JSON.toJSONString(map);
        }
        return null;
    }

    @ApiOperation("数据解密-方便测试")
    @PostMapping("/decryptedParams")
    public String getDecryptedParams(@RequestBody EncryptEntity entity) throws Exception {
        if("dev".equals(propertiesConfiguration.getEnvironment()) ||
                "test1".equals(propertiesConfiguration.getEnvironment())) {
            BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
            return JSON.toJSONString(request);
        }
        return null;
    }*/


    /**
     * @Description native获取验证码，新老版本兼容
     * @Author peijun.zhao
     * @Date 2020/2/28 9:55
     * @ModifyDate 2020/2/28 9:55
     * @Params [entity, req]
     * @Return com.pica.cloud.foundation.entity.PicaResponse EncryptEntity
     */
    @ApiOperation("获取短信验证码,无需图形验证码,如app端")
    @PostMapping(value = "/authCode")
    public PicaResponse getAuthCode(@RequestBody AesAuthCodeReq authCodeReq, HttpServletRequest req) throws Exception {
        //  验证码类型 0默认 1注册 2微信登录绑定手机 3修改手机
        //  4重置密码 5忘记密码 7患者招募提交问卷(效验) 8Appe登录绑定手机

        EncryptEntity entity = new EncryptEntity();
        if (StringUtils.isEmpty(authCodeReq.getKey()) && StringUtils.isEmpty(authCodeReq.getContent())) {
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(authCodeReq);
            logger.info("AesAuthCodeReq getAuthCode:" + JSONObject.toJSONString(authCodeReq));
            logger.info("AesAuthCodeReq getAuthCode encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(1);
            loginAes.setDeviceToken(authCodeReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(authCodeReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        } else {
            //执行原逻辑
            entity.setKey(authCodeReq.getKey());
            entity.setContent(authCodeReq.getContent());
        }

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setSourceType(super.getSourceType());
        logger.info("authCode/getAuthCode:{}", JSONObject.toJSONString(request));

        AccountUtils.checkMobilePhone(request.getMobile());

        if (request.getBizType() != null && request.getBizType().equals(1)) {
            logger.info("app-rcValidate-start");
            //  调用风控接口
            authCodeService.rcValidate(req, request, this.getRequest().getHeader("deviceInfo"), super.getSourceType());
            //  发送短信验证码
            processSysCode(request.getMobile(), request.getFlag());
            return PicaResponse.toResponse();
        } else {
            //  老版本业务(发送短信验证码)
            processSysCode(request.getMobile(), request.getFlag());
            //  记录风控数据
            authCodeService.recordRcData(req, request, super.getDeviceInfo("device_ip"));
            return PicaResponse.toResponse();
        }
    }

    @ApiOperation("获取短信验证码,无需图形验证码,如h5端")
    @PostMapping(value = "/H5/authCode")
    public PicaResponse getH5AuthCode(@RequestBody EncryptEntity entity, HttpServletRequest req) throws Exception {
        //  验证码类型 0默认 1注册 2微信登录绑定手机 3修改手机
        //  4重置密码 5忘记密码 7患者招募提交问卷(效验) 8Appe登录绑定手机
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        if (super.getSourceType() != null) {
            request.setSourceType(super.getSourceType());
        }
        AccountUtils.checkMobilePhone(request.getMobile());

        //  拼图验证
        int recordData = authCodeService.validateJigsawCode(req, request);

        //  发送短信验证码
        processSysCode(request.getMobile(), request.getFlag());

        if (recordData != -1) {
            //  记录风控数据（记录是h5端）
            authCodeService.recordRcData(req, request, super.getDeviceInfo("device_ip"));
        }

        return PicaResponse.toResponse();
    }

    /**
     * @Description web获取效验码-老版，记录风控行为
     * @Author peijun.zhao
     * @Date 2020/2/28 9:52
     * @ModifyDate 2020/2/28 9:52
     * @Params [entity]
     * @Return com.pica.cloud.foundation.entity.PicaResponse<java.lang.String>
     */
    @ApiOperation("获取短信验证码，需要图形验证码,如H5端和PC端；验证码类型 0默认 1注册 2微信登录绑定手机 3修改手机 4重置密码 5忘记密码 7患者招募提交问卷(效验)")
    @PostMapping("/account/authCode")
    public PicaResponse<String> getAuthCodeWithCaptcha(@RequestBody EncryptEntity entity,
                                                       HttpServletRequest req) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        if (super.getSourceType() != null) {
            request.setSourceType(super.getSourceType());
        }
        String mobilePhone = request.getMobile();
        String flag = request.getFlag() + "";
        String captchaToken = request.getCaptchaToken();
        String captchaAnswer = request.getCaptchaAnswer();
        //校验图形验证码
        if (!captchaService.acknowledge(captchaToken, captchaAnswer)) {
            return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "图形验证码错误");
        }
        this.checkMobilePhone(mobilePhone);
        String authCode = CommonUtil.createValidateCode();  //随机生成验证码
        String message = "您的验证码是" + authCode + ",在10分钟内有效。如非本人操作，请忽略本短信！";
        //判断账号是否已经存在
        Integer accountIdByMobilePhone = accountService.getAccountIdByMobilePhone(mobilePhone);
        long senderId = accountIdByMobilePhone == null ? 0L : accountIdByMobilePhone;
        //验证码保存到redis，失效时间10分钟
        cacheClient.set(this.getAuthCodeKey(mobilePhone, flag), authCode, 600);
        //处理验证码原子性的问题
        cacheClient.set(RegisterCodeKeyUtils.getRegisterKey(mobilePhone, authCode), 100, 600);
        logger.info(this.getAuthCodeKey(mobilePhone, flag));
        //发送短信
        super.sendMobileMessage(mobilePhone, message, senderId);

        //  记录风控数据
        authCodeService.recordRcData(req, request, super.getDeviceInfo("device_ip"));

        return PicaResponse.toResponse(StringUtils.EMPTY);
    }

    @ApiOperation("获取拼图码校验")
    @PostMapping("/jigsawCode")
    public PicaResponse getJigsawCode(@RequestBody EncryptEntity entity,
                                      HttpServletRequest req) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        return PicaResponse.toResponse(authCodeService.getJigsawCode(req, super.getSourceType(), request.getMobile(), request.getJigsawVersion()));
    }

    @ApiOperation("微信获取验证码")
    @PostMapping(value = "/authCode/wechat")
    public PicaResponse getWChatSysCode(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setFlag(AccountTypeEnum.SYSCODE_TYPE_WE_CHAT.getCode());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUnionEntity accountUnionEntity = accountUnionService.selectInfoByUnionId(request.getUnionId());
        if (accountUnionEntity != null) {
            processSysCode(request.getMobile(), request.getFlag());
            return PicaResponse.toResponse();
        }

        throw new AccountException(AccountExceptionEnum.PICA_UNBIND_MOBILE);
    }


    /**
     * 验证码发送逻辑
     * 1)随机数生成验证码；
     * 2)验证码失效时间十分钟；
     * 3)同一个业务一个手机号一分钟只能发送一次：提示：请X秒后重试.(用手机号区别用户，用flag区别业务类型)
     *
     * @param mobilePhone
     * @param flag
     */
    private void processSysCode(String mobilePhone, Integer flag) {
        String authCodeKey = this.getAuthCodeKey(mobilePhone, flag.toString());
        String authCodeKeySecure = authCodeKey + "-secure";
        //如果存在，说明刚刚发送过验证码
        if (cacheClient.exists(authCodeKey)) {
            Long time = cacheClient.get(this.getAuthCodeKey(mobilePhone, flag.toString()) + "-secure", Long.class);
            if (time == null) {
                processSendAuthCode(mobilePhone, flag, authCodeKeySecure);
            } else {
                int remainTime = 59 - (int) (System.currentTimeMillis() - time) / 1000;
                if (remainTime > 0) {
                    throw new AccountException(AccountExceptionEnum.PICA_SYSCODE_RETRY.getCode(),
                            AccountExceptionEnum.PICA_SYSCODE_RETRY.getMessage().replace("X", String.valueOf(remainTime)));
                } else {
                    processSendAuthCode(mobilePhone, flag, authCodeKeySecure);
                }
            }
        } else {
            processSendAuthCode(mobilePhone, flag, authCodeKeySecure);
        }
    }

    /**
     * 调用发送验证码的接口
     *
     * @param mobilePhone
     * @param flag
     * @param authCodeKeySecure
     */
    private void processSendAuthCode(String mobilePhone, Integer flag, String authCodeKeySecure) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "processSendAuthCode", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "mobilePhone:" + mobilePhone + ",flag:" + flag + ",authCodeKeySecure:" + authCodeKeySecure);
        long start = System.currentTimeMillis();
        String authCode = CommonUtil.createValidateCode();
        String message = "您的验证码是" + authCode + ",在10分钟内有效。如非本人操作，请忽略本短信！";
        Integer accountIdByMobilePhone = accountService.getAccountIdByMobilePhone(mobilePhone);
        long senderId = accountIdByMobilePhone == null ? 0L : accountIdByMobilePhone;
        String authCodeKey = getAuthCodeKey(mobilePhone, flag.toString());
        boolean set = cacheClient.set(authCodeKey, authCode, 600);
        logger.info(cacheClient.get(authCodeKey));
        logger.info("验证码缓存是否成功----->：" + set);
        logger.info("验证码缓存信息----->：" + authCodeKey);
        cacheClient.set(authCodeKeySecure, System.currentTimeMillis(), 60);
        //处理验证码原子性的问题
        cacheClient.set(RegisterCodeKeyUtils.getRegisterKey(mobilePhone, authCode), 100, 600);
        long end1 = System.currentTimeMillis();
        logger.info("processSendAuthCode-1 used {} million seconds", end1 - start);
        super.sendMobileMessage(mobilePhone, message, senderId);
        long end2 = System.currentTimeMillis();
        logger.info("processSendAuthCode-2 used {} million seconds", end2 - start);
        intactUtil.sendIntact(batchNo, "processSendAuthCode", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "mobilePhone:" + mobilePhone + ",flag:" + flag + ",authCodeKeySecure:" + authCodeKeySecure);

    }

    //获取验证码redis key
    private String getAuthCodeKey(String mobilePhone, String flag) {
        return Constants.AUTH_CODE_PREFIX + flag + "-" + AESUtil.encryptV0(mobilePhone);
    }

    //手机格式校验
    private void checkMobilePhone(String mobilePhone) {
        if (StringUtils.isBlank(mobilePhone) || !ValidateUtils.isMobile(mobilePhone)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的手机号");
        }
    }

    @ApiOperation("微信获取验证码")
    @PostMapping(value = "/authCode/get")
    public PicaResponse getAuthCode() {
        String cacheCode = cacheClient.get("authCode-j1VrU5MSc1uuZaEa82ZKfQ==");
        return PicaResponse.toResponse(cacheCode);
    }


}
