package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.account.account.server.util.AESUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
public class PasswordServiceImpl implements PasswordService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Value("${doubleWritingMode}")
    private boolean doubleWritingMode;

    @Override
    @Transactional
    public void modifyPassword(String mobile, String oldPwd, String pwd) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByMobile(mobile);
        if (entity != null) {
            if (entity.getPassword().equals(oldPwd)) {
                Date currentTime = new Date();
                AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
                accountInfoEntity.setId(entity.getId());
                accountInfoEntity.setModifiedId(entity.getId());
                accountInfoEntity.setModifiedTime(currentTime);
                accountInfoEntity.setPassword(pwd);
                accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
                if (doubleWritingMode) {
                    processDoubleWrite(mobile, pwd);
                }
                //密码修改日志
                LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(entity.getId(), entity.getMobilePhone(),
                        oldPwd, pwd, AccountTypeEnum.LOG_TYPE_PASSWORD.getCode());
                picaLogUtils.info(logPWDModifyEntity);
            } else {
                throw new AccountException(AccountExceptionEnum.PICA_PASSWORD_ERROR);
            }
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_NOT_EXIST);
        }
    }

    @Override
    @Transactional
    public void forgetPassword(BaseRequest request, AccountInfoEntity entity) {
        if (entity == null) {
            entity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(request.getMobile()));
        }
        if (entity != null) {
            String password = request.getPassword();
            Integer accId = entity.getId();
            Date currentTime = new Date();
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(accId);
            accountInfoEntity.setModifiedId(accId);
            accountInfoEntity.setModifiedTime(currentTime);
            accountInfoEntity.setPassword(password);
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            if (doubleWritingMode) {
                processDoubleWrite(AESUtil.encryptV0(request.getMobile()), password);
            }
            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(accId, entity.getMobilePhone(),
                    "", request.getPassword(), AccountTypeEnum.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            //未注册，请先注册
            throw new AccountException(AccountExceptionEnum.PICA_NOT_REGISTER);
        }
    }

    /**
     * 双写模式，把密码存储到p_doctor表
     *
     * @param mobile
     * @param password
     */
    private void processDoubleWrite(String mobile, String password) {
        Date currentTime = new Date();
        Doctor doctor = new Doctor();
        doctor.setPassword(password);
        doctor.setMobilePhone(mobile);
        doctor.setModifyTime(currentTime);
        doctor.setModifyId(0);
        doctorMapper.updateByMobile(doctor);
    }
}
