package com.pica.cloud.account.account.server.enums;

/**
 * @Description 统一校验响应枚举类
 * @Author Chongwen.jiang
 * @Date 2020/2/20 18:19
 * @ModifyDate 2020/2/20 18:19
 * @Params
 * @Return
 */
public enum RcRepTypeEnum {

    // 风控禁止发送
    RC_SEND_FAIL(2, "发送失败"),
    RC_TRIGGER(3, "需要触发风控滑动验证"),
    //  账号、IP、设备在黑名单内，前端提示发送成功,后端不发送短信
    RC_BLACKLIST(4, "发送成功"),
    RC_DAY_LIMIT(5, "今日获取验证码次数已超过上限，请使用账户密码登录"),
    RC_60_SECOND_LIMIT(6, "验证码发送频率过高，请{remainTime}秒后再试"),


    XXX(0, "xxxxxx");

    private Integer code;
    private String msg;

    RcRepTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setType(String msg) {
        this.msg = msg;
    }
}
