package com.pica.cloud.account.account.server.enums;

/**
 * @Description 统一校验响应枚举类
 * @Author Chongwen.jiang
 * @Date 2020/2/20 18:19
 * @ModifyDate 2020/2/20 18:19
 * @Params
 * @Return
 */
public enum BizTypeRespEnum {

    MOBILE_REG_FALSE(1, "请输入正确的手机号"),
    MOBILE_REG_TRUE(2, "手机号符合规则"),
    RC_TRIGGER(3, "需要触发风控滑动验证"),
    RC_NOT_TRIGGER(4, "不需要触发风控滑动验证"),
    MOBILE_NOT_REGIST(5, "该手机号{mobile}尚未设置密码，请先设置密码。"),
    MOBILE_REGISTED(6, "手机号已注册"),
    MOBILE_NOT_SETED_PASSWORD(7, "该手机号{mobile}尚未设置密码，请先设置密码。"),
    MOBILE_SETED_PASSWORD(8, "手机号未设置密码"),
    PWD_REG_FALSE(9, "请设置正确的密码格式"),
    PWD_REG_TRUE(10, "密码格式正确"),
    PWD_MATCH_DB(11, "密码正确"),
    PWD_MISMATCH_4(12, "密码错误,请重试"),
    PWD_MISMATCH_5(13, "密码错误次数过多，请前往找回密码"),
    MOBILE_BINDED_WECHAT(14, "该手机号已绑定其他微信号，你可以在「设置」页解除绑定"),
    MOBILE_NOT_BINDED_WECHAT(15, "该手机号未绑定微信"),
    MOBILE_BINDED_APPLE(16, "该手机号已绑定其他苹果账号"),
    MOBILE_NOT_BINDED_APPLE(17, "该手机号未绑定苹果账号"),


    XXX(10, "xxxxxx");

    private Integer code;
    private String msg;

    BizTypeRespEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setType(String msg) {
        this.msg = msg;
    }
}
