package com.pica.cloud.account.account.server.service;


import com.pica.cloud.account.account.common.req.CreateAccountReq;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.foundation.utils.entity.PicaUser;

import java.util.Map;

/**
 * @author andong
 * @create 2019/5/20
 */
public interface AccountService {

    //根据ID获取账号
    Account getById(long id);

    //根据手机号获取账号
    Account getByMobilePhone(String mobilePhone);

    //根据微信unionid获取账号
    Account getByUnionid(String unionid);

    //创建账号
    void createAccount(Account account,Integer bizType);

    // 创建账号
    Integer createAccountV2(CreateAccountReq req, PicaUser picaUser);

    //更新账号信息
    void updateAccountById(Account account);

    Map<String, String> getCache(long id);

    void refreshCache(long id);

    AccountInfoEntity getAccountByMobilePhone(String mobilePhone);

    Integer getAccountIdByMobilePhone(String mobilePhone);

}
